import {SharedAbstractRoutable} from "@app/shared/components/routables/shared-abstract/shared-abstract.routable";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {
  BaseResourceType,
  isNullOrUndefined,
  ResourceStateModel,
} from "solidify-frontend";

export abstract class SharedAbstractResourceRoutable<TResourceModel extends BaseResourceType, UResourceStateModel extends ResourceStateModel<TResourceModel>> extends SharedAbstractRoutable {
  protected constructor(protected _state: LocalStateEnum,
                        protected _parentState?: LocalStateEnum) {
    super();
  }

  protected getState(rootStateModel: any): UResourceStateModel {
    if (isNullOrUndefined(this._parentState)) {
      return rootStateModel[this._state];
    }
    const state = rootStateModel[this._parentState][this._state];
    if (isNullOrUndefined(state)) {
      console.error("There is no state corresponding to path " + this._parentState + " > " + this._state);
    }
    return state;
  }
}
