import {
  ChangeDetectorRef,
  Directive,
  OnDestroy,
  OnInit,
} from "@angular/core";
import {MatDialog} from "@angular/material/dialog";
import {ActivatedRoute} from "@angular/router";
import {
  Actions,
  ofActionCompleted,
  Store,
} from "@ngxs/store";
import {SharedAbstractDetailEditRoutable} from "@shared/components/routables/shared-abstract-detail-edit/shared-abstract-detail-edit.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {Observable} from "rxjs";
import {
  take,
  tap,
} from "rxjs/operators";
import {
  BaseResourceType,
  ModelFormControlEvent,
  ResourceNameSpace,
  ResourceStateModel,
} from "solidify-frontend";

@Directive()
export abstract class SharedAbstractDetailEditCommonRoutable<TResourceModel extends BaseResourceType, UResourceStateModel extends ResourceStateModel<TResourceModel>>
  extends SharedAbstractDetailEditRoutable<TResourceModel, UResourceStateModel> implements OnInit, OnDestroy {
  abstract readonly KEY_PARAM_NAME: keyof TResourceModel & string;

  protected constructor(protected readonly _store: Store,
                        protected readonly _route: ActivatedRoute,
                        protected readonly _actions$: Actions,
                        protected readonly _changeDetector: ChangeDetectorRef,
                        protected readonly _dialog: MatDialog,
                        protected readonly _state: LocalStateEnum,
                        protected readonly _resourceNameSpace: ResourceNameSpace,
                        protected readonly _parentState?: LocalStateEnum) {
    super(_store, _route, _actions$, _changeDetector, _dialog, _state, _resourceNameSpace, _parentState);
  }

  ngOnInit(): void {
    super.ngOnInit();
    this.retrieveCurrentModelAndResource();
  }

  update(model: ModelFormControlEvent<TResourceModel>): Observable<any> {
    this.subscribe(this._actions$.pipe(
      ofActionCompleted(this._resourceNameSpace.UpdateSuccess),
      take(1),
      tap(result => {
        if (!result.result.successful) {
          return;
        }
        this.retrieveCurrentModelWithUrl();
      }),
    ));
    return super.update(model);
  }

  ngOnDestroy(): void {
    super.ngOnDestroy();
    this.cleanState();
  }
}
