import {
  ChangeDetectorRef,
  Component,
  Input,
  OnInit,
  Output,
} from "@angular/core";
import {
  AbstractControl,
  ControlValueAccessor,
  FormControl,
  NG_VALUE_ACCESSOR,
} from "@angular/forms";
import {MatFormFieldAppearance} from "@angular/material/form-field";
import {environment} from "@environments/environment";
import {SharedAbstractPresentational} from "@shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {BaseFormDefinition} from "@shared/models/base-form-definition.model";
import {
  BehaviorSubject,
  Observable,
} from "rxjs";
import {
  distinctUntilChanged,
  pairwise,
  tap,
} from "rxjs/operators";
import {
  isNotNullNorUndefined,
  MARK_AS_TRANSLATABLE,
  ObservableUtil,
  PropertyName,
  StringUtil,
} from "solidify-frontend";

@Component({
  selector: "dlcm-shared-url-input-navigator",
  templateUrl: "./shared-url-input-navigation.presentational.html",
  styleUrls: ["./shared-url-input-navigation.presentational.scss"],
  providers: [
    {
      provide: NG_VALUE_ACCESSOR,
      multi: true,
      useExisting: SharedUrlInputNavigationPresentational,
    },
  ],
})

export class SharedUrlInputNavigationPresentational extends SharedAbstractPresentational implements OnInit, ControlValueAccessor {
  formDefinition: FormComponentFormDefinition = new FormComponentFormDefinition();

  @Input()
  placeholderToTranslate: string = MARK_AS_TRANSLATABLE("shared.UrlInput.placeholder");

  @Input()
  formControl: FormControl;

  @Input()
  readonly: boolean;

  @Input()
  disabled: boolean;

  @Input()
  appearance: MatFormFieldAppearance = this.appearanceInputMaterial;

  classInputIgnored: string = environment.classInputIgnored;

  cssClass: string = StringUtil.stringEmpty;

  private readonly _valueBS: BehaviorSubject<string[] | undefined> = new BehaviorSubject<string[] | undefined>(undefined);
  @Output("valueChange")
  readonly valueObs: Observable<string[] | undefined> = ObservableUtil.asObservable(this._valueBS);

  constructor(private readonly _changeDetector: ChangeDetectorRef) {
    super();
  }

  ngOnInit(): void {
    if (this.disabled) {
      this.cssClass = this.classInputIgnored;
    }
    this.subscribe(this.formControl.valueChanges.pipe(
      distinctUntilChanged(),
      pairwise(),
      tap(([prev, next]) => {
        this.propagateChange(next);
        this._valueBS.next(next);
        if (prev === next) {
          this.formControl.markAsPristine();
        }
        this._changeDetector.detectChanges();
      }),
    ));
  }

  propagateChange = (__: any) => {};

  registerOnChange(fn: any): void {
    this.propagateChange = fn;
  }

  registerOnTouched(fn: any): void {
  }

  setDisabledState(isDisabled: boolean): void {
  }

  writeValue(value: string[]): void {
  }

  navigateToUrl(event: Event, fd: AbstractControl): void {
    if (isNotNullNorUndefined(event)) {
      event.stopPropagation();
      event.preventDefault();
    }
    window.open(fd.value, "_blank");
  }

}

class FormComponentFormDefinition extends BaseFormDefinition {
  @PropertyName() url: string;
}

