import {
  ChangeDetectionStrategy,
  Component,
  HostBinding,
  Input,
} from "@angular/core";
import {SharedAbstractPresentational} from "@shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {StatusModel} from "@shared/models/status.model";

@Component({
  selector: "dlcm-shared-status",
  templateUrl: "./shared-status.presentational.html",
  styleUrls: ["./shared-status.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class SharedStatusPresentational extends SharedAbstractPresentational {
  @Input()
  statusModel: StatusModel;

  @HostBinding("class.is-label")
  @Input()
  label: string | undefined = LabelTranslateEnum.status;

  @HostBinding("class.is-label-inline")
  @Input()
  isInline: boolean = false;

  @HostBinding("class.take-all-width")
  @Input()
  takeAllWidth: boolean = false;
}
