import {
  ChangeDetectionStrategy,
  Component,
  HostBinding,
  Input,
  Output,
} from "@angular/core";
import {SharedAbstractPresentational} from "@shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {
  BehaviorSubject,
  Observable,
} from "rxjs";
import {ObservableUtil} from "solidify-frontend";

@Component({
  selector: "dlcm-shared-star-rating",
  templateUrl: "./shared-star-rating.presentational.html",
  styleUrls: ["./shared-star-rating.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})

export class SharedStarRatingPresentational extends SharedAbstractPresentational {
  @Input()
  noValue: boolean = false;

  @HostBinding("class.is-editable")
  @Input()
  isEditable: boolean = false;

  @Input()
  numberReview: number | undefined = undefined;

  @Input()
  rating: number;

  @Input()
  maxStarsNumber: number = 3;

  @HostBinding("class.is-label")
  @Input()
  label: string | undefined;

  @Input()
  tooltipToTranslate: string | undefined;

  @HostBinding("class.is-disabled")
  @Input()
  disabled: boolean = false;

  @HostBinding("class.is-center")
  @Input()
  center: boolean = false;

  private readonly _rateBS: BehaviorSubject<number> = new BehaviorSubject<number>(undefined);
  @Output("rateChange")
  readonly rateObs: Observable<number> = ObservableUtil.asObservable(this._rateBS);

  starsArray(): number[] {
    return Array(this.maxStarsNumber);
  }

  setRating(index: number): void {
    if (!this.isEditable) {
      return;
    }
    this.rating = index + 1;
    this._rateBS.next(this.rating);
  }

  tempRating: number;

  cleanTempRating(): void {
    if (!this.isEditable) {
      return;
    }
    this.tempRating = undefined;
  }

  setTempRating(index: number): void {
    if (!this.isEditable) {
      return;
    }
    this.tempRating = index + 1;
  }
}
