import {
  ChangeDetectionStrategy,
  Component,
  Inject,
  NgZone,
} from "@angular/core";
import {
  MAT_SNACK_BAR_DATA,
  MatSnackBarRef,
} from "@angular/material/snack-bar";
import {IconNameEnum} from "@shared/enums/icon-name.enum";
import {
  AbstractSnackbarPresentational,
  isNullOrUndefined,
  NotificationTypeEnum,
  SnackbarData,
} from "solidify-frontend";

@Component({
  selector: "dlcm-shared-snackbar",
  templateUrl: "./shared-snackbar.presentational.html",
  styleUrls: ["./shared-snackbar.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class SharedSnackbarPresentational extends AbstractSnackbarPresentational {
  get notificationTypeEnum(): typeof NotificationTypeEnum {
    return NotificationTypeEnum;
  }

  get iconNameEnum(): typeof IconNameEnum {
    return IconNameEnum;
  }

  constructor(public snackbarRef: MatSnackBarRef<SharedSnackbarPresentational>,
              @Inject(MAT_SNACK_BAR_DATA) public data: SharedSnackbarOption,
              private _ngZone: NgZone) {
    super();
  }

  getIcon(): IconNameEnum | undefined {
    if (!isNullOrUndefined(this.data.icon)) {
      return this.data.icon;
    }

    switch (this.data.category) {
      case NotificationTypeEnum.success:
        return IconNameEnum.success;
      case NotificationTypeEnum.information:
        return IconNameEnum.information;
      case NotificationTypeEnum.warning:
        return IconNameEnum.warning;
      case NotificationTypeEnum.error:
        return IconNameEnum.error;
    }

    return undefined;
  }

  close($event: MouseEvent): void {
    this._ngZone.run(() => this.snackbarRef.dismiss());
  }

  actionButton($event: MouseEvent): void {
    this.close($event);
    this.data?.action.callback();
  }
}

export interface SharedSnackbarOption extends SnackbarData {
  icon?: IconNameEnum;
}
