import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  ElementRef,
  Input,
  OnInit,
  Output,
} from "@angular/core";
import {FormBuilder} from "@angular/forms";
import {
  Actions,
  Store,
} from "@ngxs/store";
import {SharedSearchableAbstractContentPresentational} from "@shared/components/presentationals/shared-searchable-abstract-content/shared-searchable-abstract-content.presentational";
import {SharedSearchableSingleSelectPresentational} from "@shared/components/presentationals/shared-searchable-single-select/shared-searchable-single-select.presentational";
import {
  BehaviorSubject,
  Observable,
} from "rxjs";
import {
  BaseResourceType,
  isFalse,
  isNullOrUndefined,
  ObservableUtil,
  ResourceStateModel,
} from "solidify-frontend";

@Component({
  selector: "dlcm-shared-searchable-single-select-content",
  templateUrl: "./shared-searchable-single-select-content.presentational.html",
  styleUrls: ["./shared-searchable-single-select-content.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class SharedSearchableSingleSelectContentPresentational<TResource extends BaseResourceType> extends SharedSearchableAbstractContentPresentational<TResource> implements OnInit {
  @Input()
  host: SharedSearchableSingleSelectPresentational<ResourceStateModel<TResource>, TResource>;

  private readonly _valueBS: BehaviorSubject<TResource | undefined> = new BehaviorSubject<TResource | undefined>(undefined);
  @Output("valueChange")
  readonly valueObs: Observable<TResource | undefined> = ObservableUtil.asObservable(this._valueBS);

  constructor(protected readonly _store: Store,
              protected readonly _fb: FormBuilder,
              protected readonly _elementRef: ElementRef,
              protected readonly _changeDetector: ChangeDetectorRef,
              protected readonly _actions$: Actions) {
    super(_store, _fb, _elementRef, _changeDetector, _actions$);
  }

  ngOnInit(): void {
    super.ngOnInit();
  }

  select(value: TResource, force: boolean = false): void {
    if (isNullOrUndefined(value)) {
      return;
    }
    this.host.isDefaultValueSelected = false;
    if (this.isActive(value) && isFalse(force)) {
      return;
    }
    this._valueBS.next(value);
  }
}



