import {
  AfterViewInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  ElementRef,
  Input,
  OnInit,
  Output,
} from "@angular/core";
import {FormBuilder} from "@angular/forms";
import {
  Actions,
  Store,
} from "@ngxs/store";
import {SharedSearchableAbstractContentPresentational} from "@shared/components/presentationals/shared-searchable-abstract-content/shared-searchable-abstract-content.presentational";
import {SharedSearchableMultiSelectPresentational} from "@shared/components/presentationals/shared-searchable-multi-select/shared-searchable-multi-select.presentational";
import {
  BehaviorSubject,
  Observable,
} from "rxjs";
import {
  BaseResourceType,
  isNullOrUndefined,
  ObservableUtil,
  ResourceStateModel,
} from "solidify-frontend";

@Component({
  selector: "dlcm-shared-searchable-multi-select-content",
  templateUrl: "./shared-searchable-multi-select-content.presentational.html",
  styleUrls: ["./shared-searchable-multi-select-content.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class SharedSearchableMultiSelectContentPresentational<TResource extends BaseResourceType> extends SharedSearchableAbstractContentPresentational<TResource> implements OnInit, AfterViewInit {
  @Input()
  host: SharedSearchableMultiSelectPresentational<ResourceStateModel<TResource>, TResource>;

  private readonly _valueAddedBS: BehaviorSubject<TResource | undefined> = new BehaviorSubject<TResource | undefined>(undefined);
  @Output("valueAddedChange")
  readonly valueAddedObs: Observable<TResource | undefined> = ObservableUtil.asObservable(this._valueAddedBS);

  private readonly _valueRemovedBS: BehaviorSubject<TResource | undefined> = new BehaviorSubject<TResource | undefined>(undefined);
  @Output("valueRemovedChange")
  readonly valueRemovedObs: Observable<TResource | undefined> = ObservableUtil.asObservable(this._valueRemovedBS);

  constructor(protected readonly _store: Store,
              protected readonly _fb: FormBuilder,
              protected readonly _elementRef: ElementRef,
              protected readonly _changeDetector: ChangeDetectorRef,
              protected readonly _actions$: Actions) {
    super(_store, _fb, _elementRef, _changeDetector, _actions$);
  }

  select(value: TResource): void {
    if (isNullOrUndefined(value)) {
      return;
    }
    if (this.isActive(value)) {
      this._valueRemovedBS.next(value);
      return;
    }
    this._valueAddedBS.next(value);
    const indexOf = this.listLastSelection.indexOf(value);
    if (indexOf !== -1) {
      this.listLastSelection.splice(indexOf, 1);
    }
  }
}



