import {
  animate,
  state,
  style,
  transition,
  trigger,
} from "@angular/animations";
import {
  ChangeDetectionStrategy,
  Component,
  Input,
} from "@angular/core";
import {SharedAbstractPresentational} from "@app/shared/components/presentationals/shared-abstract/shared-abstract.presentational";

@Component({
  selector: "dlcm-shared-panel-expandable",
  templateUrl: "./shared-panel-expandable.presentational.html",
  styleUrls: ["./shared-panel-expandable.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
  animations: [
    trigger("buttonAnimation", [
      state("void", style({transform: "rotate(180deg)"})),
      transition(":enter", animate("600ms ease")),
      transition(":leave", animate("300ms ease")),
    ]),
    trigger("contentAnimation", [
      state("void", style({transform: "translateY(-100%)"})),
      transition(":enter", animate("600ms ease")),
      transition(":leave", animate("300ms ease")),
    ]),
  ],
})
export class SharedPanelExpandablePresentational extends SharedAbstractPresentational {
  @Input()
  titleToTranslate: string;

  @Input()
  isOpen: boolean = false;

  constructor() {
    super();
  }

  toggle(): void {
    this.isOpen = !this.isOpen;
  }
}
