import {
  ChangeDetectionStrategy,
  Component,
  Input,
  Output,
  ViewChild,
} from "@angular/core";
import {
  MatPaginator,
  PageEvent,
} from "@angular/material/paginator";
import {SharedAbstractPresentational} from "@app/shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {
  BehaviorSubject,
  Observable,
} from "rxjs";
import {
  ObservableUtil,
  Paging,
} from "solidify-frontend";
import {environment} from "../../../../../environments/environment";

@Component({
  selector: "dlcm-shared-paginator",
  templateUrl: "./shared-paginator.presentational.html",
  styleUrls: ["./shared-paginator.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class SharedPaginatorPresentational extends SharedAbstractPresentational {
  @Input()
  pageSizeOptions: number[] = environment.pageSizeOptions;

  @Input()
  pagingModel: Paging;

  private readonly _pageBS: BehaviorSubject<Paging | undefined> = new BehaviorSubject<Paging | undefined>(undefined);

  @Output("pageChange")
  readonly pageObs: Observable<Paging | undefined> = ObservableUtil.asObservable(this._pageBS);

  @ViewChild("paginator")
  paginator: MatPaginator;

  constructor() {
    super();
  }

  onPageEvent(pageEventMaterial: PageEvent): void {
    this._pageBS.next(this.adaptMaterialPageEventToPagingModel(pageEventMaterial));
  }

  adaptMaterialPageEventToPagingModel(pageEventMaterial: PageEvent): Paging {
    return {
      length: pageEventMaterial.length,
      pageIndex: pageEventMaterial.pageIndex,
      pageSize: pageEventMaterial.pageSize,
    } as Paging;
  }
}
