import {
  ChangeDetectionStrategy,
  Component,
  Input,
  Output,
} from "@angular/core";
import {FormBuilder} from "@angular/forms";
import {Store} from "@ngxs/store";
import {SharedAbstractContentPresentational} from "@shared/components/presentationals/shared-abstract-content/shared-abstract-content.presentational";
import {
  BehaviorSubject,
  Observable,
} from "rxjs";
import {
  BaseResourceType,
  ObservableUtil,
  MARK_AS_TRANSLATABLE,
} from "solidify-frontend";

@Component({
  selector: "dlcm-shared-multi-select-content",
  templateUrl: "./shared-multi-select-content.presentational.html",
  styleUrls: ["./shared-multi-select-content.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class SharedMultiSelectContentPresentational<TResource extends BaseResourceType> extends SharedAbstractContentPresentational<TResource> {

  @Input()
  host: any; // (SharedMultiSelectPresentational<TResource>;) CAUSE RUNTIME ERROR WHEN AOT BUILD WITHOUT SOURCEMAP. Following error on polyfills.js: Uncaught TypeError: Object prototype may only be an Object or null: undefined

  private readonly _valueAddedBS: BehaviorSubject<TResource | undefined> = new BehaviorSubject<TResource | undefined>(undefined);
  @Output("valueAddedChange")
  readonly valueAddedObs: Observable<TResource | undefined> = ObservableUtil.asObservable(this._valueAddedBS);

  private readonly _valueRemovedBS: BehaviorSubject<TResource | undefined> = new BehaviorSubject<TResource | undefined>(undefined);
  @Output("valueRemovedChange")
  readonly valueRemovedObs: Observable<TResource | undefined> = ObservableUtil.asObservable(this._valueRemovedBS);

  readonly noDataToSelect: string = MARK_AS_TRANSLATABLE("component.multiSelect.noDataToSelect");

  constructor(protected _store: Store,
              protected _fb: FormBuilder) {
    super();
  }

  select(value: TResource): void {
    if (this.isActive(value)) {
      this._valueRemovedBS.next(value);
      return;
    }
    this._valueAddedBS.next(value);
  }
}



