import {
  ChangeDetectionStrategy,
  Component,
  Input,
} from "@angular/core";
import {
  DomSanitizer,
  SafeResourceUrl,
} from "@angular/platform-browser";
import {environment} from "@environments/environment";
import {SharedAbstractPresentational} from "@shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {isNullOrUndefined} from "solidify-frontend";

@Component({
  selector: "dlcm-shared-image-display",
  templateUrl: "./shared-image-display.presentational.html",
  styleUrls: ["./shared-image-display.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class SharedImageDisplayPresentational extends SharedAbstractPresentational {
  @Input()
  image: string | undefined;

  defaultImageArchive: string = `assets/themes/${environment.theme}/toolbar-header-image.svg`;
  displayFallback: boolean = true;
  loading: boolean = true;

  constructor(protected readonly _sanitizer: DomSanitizer) {
    super();
  }

  sanitizeUrl(url: string | undefined): undefined | SafeResourceUrl {
    if (isNullOrUndefined(url)) {
      return undefined;
    } else {
      return this._sanitizer.bypassSecurityTrustResourceUrl(url);
    }
  }

  determineDisplayFallback(image: HTMLImageElement): void {
    this.loading = false;
    if (image.width > 0) {
      this.displayFallback = false;
    }
  }

  unableToLoad(image: HTMLImageElement): void {
    this.loading = false;
    this.displayFallback = true;
  }
}
