import {
  ChangeDetectionStrategy,
  Component,
  ElementRef,
  Input,
  Renderer2,
} from "@angular/core";
import {SharedAbstractPresentational} from "@app/shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {IconLibEnum} from "@shared/enums/icon-lib.enum";
import {IconNameEnum} from "@shared/enums/icon-name.enum";
import {IconHelper} from "@shared/helpers/icon.helper";
import {isNullOrUndefined} from "solidify-frontend";

@Component({
  selector: "dlcm-shared-icon",
  templateUrl: "./shared-icon.presentational.html",
  styleUrls: ["./shared-icon.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class SharedIconPresentational extends SharedAbstractPresentational {
  private readonly CLASS_FONT_AWESOME: string = "fa-icon";
  private readonly CLASS_MATERIAL: string = "mat-icon";
  private readonly CLASS_IMAGE: string = "image";
  readonly PATH_TO_IMAGE: string = "assets/images/";

  private _iconName: IconNameEnum;

  @Input()
  set iconName(value: IconNameEnum) {
    this._iconName = value;
    this.iconInfo = IconHelper.getIcon(value);

    if (isNullOrUndefined(this.iconInfo)) {
      return;
    }

    this.renderer.removeClass(this.el.nativeElement, this.CLASS_MATERIAL);
    this.renderer.removeClass(this.el.nativeElement, this.CLASS_FONT_AWESOME);
    this.renderer.removeClass(this.el.nativeElement, this.CLASS_IMAGE);

    if (this.iconInfo.lib === IconLibEnum.materialIcon) {
      this.renderer.addClass(this.el.nativeElement, this.CLASS_MATERIAL);
    } else if (this.iconInfo.lib === IconLibEnum.fontAwesome) {
      this.renderer.addClass(this.el.nativeElement, this.CLASS_FONT_AWESOME);
    } else if (this.iconInfo.lib === IconLibEnum.image) {
      this.renderer.addClass(this.el.nativeElement, this.CLASS_IMAGE);
    }
  }

  iconInfo: IconInfos;

  get iconLib(): typeof IconLibEnum {
    return IconLibEnum;
  }

  constructor(private readonly renderer: Renderer2,
              private readonly el: ElementRef) {
    super();
  }
}

export interface IconInfos {
  lib: IconLibEnum;
  icon: string;
  name: IconNameEnum;
}
