import {
  ChangeDetectionStrategy,
  Component,
  Input,
} from "@angular/core";
import {
  ControlValueAccessor,
  FormControl,
  NG_VALUE_ACCESSOR,
} from "@angular/forms";
import {SharedAbstractPresentational} from "@app/shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {
  isNonEmptyArray,
  isNullOrUndefined,
} from "solidify-frontend";

@Component({
  selector: "dlcm-shared-field-error",
  templateUrl: "./shared-field-error.presentational.html",
  styleUrls: ["./shared-field-error.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
  providers: [
    {
      provide: NG_VALUE_ACCESSOR,
      multi: true,
      useExisting: SharedFieldErrorPresentational,
    },
  ],
})
export class SharedFieldErrorPresentational extends SharedAbstractPresentational implements ControlValueAccessor {
  private readonly _REQUIRED: string = "required";

  @Input()
  set detectChange(value: any) {
  }

  @Input()
  formControl: FormControl;

  getBackendFormError(): ErrorWrapper[] {
    const errors: ErrorWrapper[] = [];
    if (!isNullOrUndefined(this.formControl.errors)) {

      // if (isTruthy(this.formControl.errors.required)) {
      //   errors.push({errorMessage: this._REQUIRED, toTranslate: true});
      // }

      if (isNonEmptyArray(this.formControl.errors.errorsFromBackend)) {
        const errorsBackend: string[] = this.formControl.errors.errorsFromBackend;
        errorsBackend.forEach(error => {
          errors.push({errorMessage: error, toTranslate: false});
        });
      }
    }
    return errors;
  }

  propagateChange = (__: any) => {};

  registerOnChange(fn: any): void {
    this.propagateChange = fn;
  }

  registerOnTouched(fn: any): void {
  }

  setDisabledState(isDisabled: boolean): void {
  }

  writeValue(value: string[]): void {
  }
}

interface ErrorWrapper {
  errorMessage: string;
  toTranslate: boolean;
}
