import {
  ChangeDetectionStrategy,
  Component,
  Input,
  Output,
  ViewChild,
} from "@angular/core";
import {MatMenu} from "@angular/material/menu";
import {environment} from "@environments/environment";
import {SharedAbstractPresentational} from "@shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {
  BehaviorSubject,
  Observable,
} from "rxjs";
import {
  ClipboardUtil,
  MARK_AS_TRANSLATABLE,
  NotificationService,
  ObservableUtil,
} from "solidify-frontend";

@Component({
  selector: "dlcm-shared-doi-menu",
  templateUrl: "./shared-doi-menu.presentational.html",
  styleUrls: ["./shared-doi-menu.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
  exportAs: "doiMenu",
})
export class SharedDoiMenuPresentational extends SharedAbstractPresentational {
  @Input()
  doi: string;

  @ViewChild(MatMenu, {static: true}) menu: MatMenu;

  @Input()
  mode: "deposit" | "archive";

  private readonly _shortDoiBS: BehaviorSubject<GetShortDoiWrapper | undefined> = new BehaviorSubject<GetShortDoiWrapper | undefined>(undefined);
  @Output("getShortDoi")
  readonly shortDoiObs: Observable<GetShortDoiWrapper | undefined> = ObservableUtil.asObservable(this._shortDoiBS);

  constructor(private readonly notificationService: NotificationService) {
    super();
  }

  copyShortDoi(): void {
    this._shortDoiBS.next({
      longDoi: this.doi,
      isFullUrl: false,
    });
  }

  copyLongDoi(): void {
    ClipboardUtil.copyStringToClipboard(this.doi);
    this.notificationService.showInformation(MARK_AS_TRANSLATABLE("doi.notification.longDoiCopyToClipboard"));
  }

  copyUrlShortDoi(): void {
    this._shortDoiBS.next({
      longDoi: this.doi,
      isFullUrl: true,
    });
  }

  copyUrlLongDoi(): void {
    ClipboardUtil.copyStringToClipboard(environment.doiLink + this.doi);
    this.notificationService.showInformation(MARK_AS_TRANSLATABLE("doi.notification.urlLongDoiCopyToClipboard"));
  }
}

export interface GetShortDoiWrapper {
  longDoi: string;
  isFullUrl: boolean;
}
