import {NO_ERRORS_SCHEMA} from "@angular/core";
import {
  async,
  ComponentFixture,
  TestBed,
} from "@angular/core/testing";
import {TranslateService} from "@ngx-translate/core";
import {QueryParameters} from "solidify-frontend";
import {MockTranslatePipe} from "../../../../../test-helpers/mock-translate.pipe";
import {MockTranslateService} from "../../../../../test-helpers/mock-translate.service";

import {SharedDataTablePresentational} from "./shared-data-table.presentational";

xdescribe("SharedDataTablePresentational", () => {
  let component: SharedDataTablePresentational<any>;
  let fixture: ComponentFixture<any>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      declarations: [SharedDataTablePresentational, MockTranslatePipe],
      providers: [
        {
          provide: TranslateService,
          useClass: MockTranslateService,
        },
      ],
      schemas: [NO_ERRORS_SCHEMA],
    })
      .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(SharedDataTablePresentational);
    component = fixture.componentInstance;
    component.queryParameters = new QueryParameters();
    component.columns = [];
    fixture.detectChanges();
  });

  it("should create", () => {
    expect(component).toBeTruthy();
  });

  describe("getData", () => {
    it("should return nested data", () => {
      const when = "2019-08-22T09:34:27.603+0200";
      const result = component.getData({
          creation: {
            when: when,
          },
        },
        {field: "creation.when"} as any);

      expect(result).toBe(when);
    });
  });
});
