import {
  ChangeDetectionStrategy,
  Component,
  Input,
} from "@angular/core";
import {SharedAbstractPresentational} from "@app/shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {Checksum} from "@deposit/models/checksum.model";
import {
  ClipboardUtil,
  NotificationService,
  MARK_AS_TRANSLATABLE,
} from "solidify-frontend";

@Component({
  selector: "dlcm-shared-checksum",
  templateUrl: "./shared-checksum.presentational.html",
  styleUrls: ["./shared-checksum.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class SharedChecksumPresentational extends SharedAbstractPresentational {
  @Input()
  checksums: Checksum[];

  constructor(private readonly _notificationService: NotificationService) {
    super();
  }

  copy(checksum: Checksum): void {
    ClipboardUtil.copyStringToClipboard(checksum.checksum);
    this._notificationService.showInformation(MARK_AS_TRANSLATABLE("app.notification.checksumCopy"));
  }
}
