import {
  Directive,
  HostListener,
} from "@angular/core";
import {Select} from "@ngxs/store";
import {SharedAbstractPresentational} from "@shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {ICanDeactivate} from "@shared/models/can-deactivate.model";
import {LocalStateModel} from "@shared/models/local-state.model";
import {Observable} from "rxjs";
import {
  take,
  tap,
} from "rxjs/operators";
import {isFalse} from "solidify-frontend";

@Directive()
export abstract class CanDeactivatePresentational extends SharedAbstractPresentational implements ICanDeactivate {
  @Select((state: LocalStateModel) => state.application.ignorePreventLeavePopup) ignorePreventLeavePopupObs: Observable<boolean>;

  abstract canDeactivate(): boolean;

  @HostListener("window:beforeunload", ["$event"])
  leaveWithoutSaveNotification($event: Event): void {
    this.subscribe(this.ignorePreventLeavePopupObs.pipe(
      take(1),
      tap(ignorePreventLeavePopup => {
        if (isFalse(ignorePreventLeavePopup) && !this.canDeactivate()) {
          $event.returnValue = true;
        }
      }),
      ),
    );
  }
}
