import {
  Component,
  ElementRef,
  Input,
  OnInit,
  Output,
} from "@angular/core";
import {SharedAbstractButtonToolbarPresentational} from "@shared/components/presentationals/shared-abstract-button-toolbar/shared-abstract-button-toolbar.presentational";
import {DataTestEnum} from "@shared/enums/data-test.enum";
import {IconNameEnum} from "@shared/enums/icon-name.enum";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {
  BehaviorSubject,
  Observable,
} from "rxjs";
import {
  BaseResource,
  ObservableUtil,
} from "solidify-frontend";

@Component({
  selector: "dlcm-shared-button-toolbar-list",
  templateUrl: "./shared-button-toolbar-list.presentational.html",
  styleUrls: ["./shared-button-toolbar-list.presentational.scss"],
  // changeDetection: ChangeDetectionStrategy.OnPush, // TODO Find a way to use OnPush strategy and still have ability to update disable and display condition (@Input immutable for change ? Observable ?)
})
export class SharedButtonToolbarListPresentational<TResourceModel extends BaseResource> extends SharedAbstractButtonToolbarPresentational<TResourceModel> implements OnInit {
  @Input()
  readonly keyCreateButtonToTranslate: string = LabelTranslateEnum.create;

  @Input()
  readonly backAvailable: boolean = true;

  @Input()
  readonly createAvailable: boolean = true;

  private readonly _createBS: BehaviorSubject<ElementRef> = new BehaviorSubject<ElementRef>(undefined);
  @Output("createChange")
  readonly createObs: Observable<ElementRef> = ObservableUtil.asObservable(this._createBS);

  ngOnInit(): void {
    this.listOriginalButton = [
      {
        color: "primary",
        icon: IconNameEnum.back,
        labelToTranslate: (resource) => this.keyBackButtonToTranslate,
        order: 10,
        displayCondition: () => this.backAvailable,
        callback: () => this.backToList(),
        dataTest: DataTestEnum.back,
      },
      {
        color: "primary",
        typeButton: "flat-button",
        icon: IconNameEnum.create,
        labelToTranslate: (resource) => this.keyCreateButtonToTranslate,
        order: 20,
        displayCondition: (currentModel) => this.createAvailable,
        callback: (currentModel, buttonElementRef) => this.create(buttonElementRef),
        dataTest: DataTestEnum.create,
      },
    ];
    super.ngOnInit();
  }

  create(buttonElementRef: ElementRef): void {
    this._createBS.next(buttonElementRef);
  }
}
