import {
  Component,
  Input,
  OnInit,
  Output,
} from "@angular/core";
import {DepositDataFile} from "@deposit/models/deposit-data-file.model";
import {SharedAbstractButtonToolbarPresentational} from "@shared/components/presentationals/shared-abstract-button-toolbar/shared-abstract-button-toolbar.presentational";
import {SharedAbstractFormPresentational} from "@shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational";
import {DataTestEnum} from "@shared/enums/data-test.enum";
import {IconNameEnum} from "@shared/enums/icon-name.enum";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {
  BehaviorSubject,
  Observable,
} from "rxjs";
import {
  BaseResource,
  isNullOrUndefined,
  ObservableUtil,
} from "solidify-frontend";

@Component({
  selector: "dlcm-shared-button-toolbar-detail",
  templateUrl: "./shared-button-toolbar-detail.presentational.html",
  styleUrls: ["./shared-button-toolbar-detail.presentational.scss"],
  // changeDetection: ChangeDetectionStrategy.OnPush, // TODO Find a way to use OnPush strategy and still have ability to update disable and display condition (@Input immutable for change ? Observable ?)
})
export class SharedButtonToolbarDetailPresentational<TResourceModel extends BaseResource> extends SharedAbstractButtonToolbarPresentational<TResourceModel> implements OnInit {
  @Input()
  readonly keyDeleteButtonToTranslate: string = LabelTranslateEnum.delete;

  @Input()
  readonly keyBackToDetailButtonToTranslate: string = LabelTranslateEnum.exitEditMode;

  @Input()
  readonly keySaveButtonToTranslate: string = LabelTranslateEnum.save;

  @Input()
  readonly keyCreateButtonToTranslate: string = LabelTranslateEnum.create;

  @Input()
  editAvailable: boolean = true;

  @Input()
  deleteAvailable: boolean = true;

  @Input()
  saveAvailable: boolean = true;

  @Input()
  historyAvailable: boolean = false;

  @Input()
  currentModel: TResourceModel;

  @Input()
  readonly formPresentational: SharedAbstractFormPresentational<TResourceModel>;

  private _mode: "edit" | "create" | "detail";

  @Input()
  set mode(mode: "edit" | "create" | "detail") {
    if (!isNullOrUndefined(mode) && !isNullOrUndefined(this._mode)) {
      if (this._mode !== mode) {
        this._mode = mode;
        this.focusFirstButtonElement();
      }
    } else {
      this._mode = mode;
    }

  }

  get mode(): "edit" | "create" | "detail" {
    return this._mode;
  }

  private readonly _showHistoryBS: BehaviorSubject<DepositDataFile | undefined> = new BehaviorSubject<DepositDataFile | undefined>(undefined);
  @Output("showHistoryChange")
  readonly showHistoryObs: Observable<DepositDataFile | undefined> = ObservableUtil.asObservable(this._showHistoryBS);

  private readonly _editBS: BehaviorSubject<void> = new BehaviorSubject<void>(undefined);
  @Output("editChange")
  readonly editObs: Observable<void> = ObservableUtil.asObservable(this._editBS);

  private readonly _deleteBS: BehaviorSubject<void> = new BehaviorSubject<void>(undefined);
  @Output("deleteChange")
  readonly deleteObs: Observable<void> = ObservableUtil.asObservable(this._deleteBS);

  private readonly _backToDetailBS: BehaviorSubject<void> = new BehaviorSubject<void>(undefined);
  @Output("backToDetailChange")
  readonly backToDetailObs: Observable<void> = ObservableUtil.asObservable(this._backToDetailBS);

  ngOnInit(): void {
    this.listOriginalButton = [
      {
        color: "primary",
        icon: IconNameEnum.back,
        labelToTranslate: (resource) => this.keyBackToDetailButtonToTranslate,
        order: 10,
        callback: () => this.backToDetail(),
        displayCondition: (resource) => this.mode === "edit",
      },
      {
        color: "primary",
        icon: IconNameEnum.back,
        labelToTranslate: (resource) => this.keyBackButtonToTranslate,
        order: 20,
        dataTest: DataTestEnum.back,
        callback: () => this.backToList(),
        displayCondition: (resource) => this.mode === "detail" || this.mode === "create",
      },
      {
        color: "primary",
        icon: IconNameEnum.delete,
        labelToTranslate: (resource) => this.keyDeleteButtonToTranslate,
        order: 40,
        dataTest: DataTestEnum.delete,
        callback: () => this.delete(),
        displayCondition: (resource) => this.mode === "detail" && this.deleteAvailable,
        disableCondition: (resource) => !resource,
      },
      {
        color: "primary",
        typeButton: "flat-button",
        icon: IconNameEnum.save,
        labelToTranslate: (resource) => this.mode === "create" ? this.keyCreateButtonToTranslate : this.keySaveButtonToTranslate,
        order: 50,
        dataTest: DataTestEnum.save,
        callback: () => this.save(),
        displayCondition: (resource) => this.mode !== "detail" && this.saveAvailable,
        disableCondition: () => this.formPresentational?.form?.pristine || this.formPresentational?.form?.invalid,
      },
    ];
    super.ngOnInit();
  }

  edit(): void {
    if (this.editAvailable) {
      this._editBS.next();
    }
  }

  delete(): void {
    if (this.deleteAvailable && !isNullOrUndefined(this.currentModel)) {
      this._deleteBS.next();
    }
  }

  backToDetail(): void {
    this._backToDetailBS.next();
  }

  showHistory(): void {
    this._showHistoryBS.next(this.currentModel);
  }

  private save(): void {
    this.formPresentational.onSubmit();
  }
}
