import {
  ChangeDetectionStrategy,
  Component,
  Output,
} from "@angular/core";
import {SharedAbstractPresentational} from "@app/shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {
  BehaviorSubject,
  Observable,
} from "rxjs";
import {ObservableUtil} from "solidify-frontend";

@Component({
  selector: "dlcm-shared-button-status-history",
  templateUrl: "./shared-button-status-history.presentational.html",
  styleUrls: ["./shared-button-status-history.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class SharedButtonStatusHistoryPresentational extends SharedAbstractPresentational {
  private readonly _showHistoryBS: BehaviorSubject<void> = new BehaviorSubject<void>(undefined);
  @Output("showHistory")
  readonly showHistoryObs: Observable<void> = ObservableUtil.asObservable(this._showHistoryBS);

  constructor() {
    super();
  }

  showHistory(): void {
    this._showHistoryBS.next();
  }
}
