import {
  ChangeDetectionStrategy,
  Component,
  Input,
  Output,
} from "@angular/core";
import {SharedAbstractPresentational} from "@shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {
  BehaviorSubject,
  Observable,
} from "rxjs";
import {ObservableUtil} from "solidify-frontend";

@Component({
  selector: "dlcm-shared-button-refresh",
  templateUrl: "./shared-button-refresh.presentational.html",
  styleUrls: ["./shared-button-refresh.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})

export class SharedButtonRefreshPresentational extends SharedAbstractPresentational {
  @Input("isLoading")
  isLoading: boolean;

  private readonly _refreshBS: BehaviorSubject<void> = new BehaviorSubject<void>(undefined);
  @Output("refresh")
  readonly refreshObs: Observable<void> = ObservableUtil.asObservable(this._refreshBS);

  constructor() {
    super();
  }

  refresh(): void {
    this._refreshBS.next();
  }
}
