import {
  ChangeDetectionStrategy,
  Component,
  Input,
} from "@angular/core";
import {SharedAbstractPresentational} from "@app/shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {
  BaseResourceType,
  ClipboardUtil,
  NotificationService,
  MARK_AS_TRANSLATABLE,
} from "solidify-frontend";

@Component({
  selector: "dlcm-shared-button-id",
  templateUrl: "./shared-button-id.presentational.html",
  styleUrls: ["./shared-button-id.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class SharedButtonIdPresentational extends SharedAbstractPresentational {
  @Input()
  resource: BaseResourceType;

  constructor(private readonly _notificationService: NotificationService) {
    super();
  }

  copyToClipboard(): void {
    ClipboardUtil.copyStringToClipboard(this.resource.resId);
    this._notificationService.showInformation(MARK_AS_TRANSLATABLE("app.notification.idCopyToClipboard"));
  }
}
