import {NO_ERRORS_SCHEMA} from "@angular/core";
import {
  async,
  ComponentFixture,
  TestBed,
} from "@angular/core/testing";
import {RouterTestingModule} from "@angular/router/testing";
import {TranslateService} from "@ngx-translate/core";
import {SolidifyFrontendModule} from "solidify-frontend";
import {MockTranslatePipe} from "../../../../../test-helpers/mock-translate.pipe";
import {MockTranslateService} from "../../../../../test-helpers/mock-translate.service";

import {SharedBreadcrumbPresentational} from "./shared-breadcrumb.presentational";

describe("SharedBreadcrumbPresentational", () => {
  let component: SharedBreadcrumbPresentational;
  let fixture: ComponentFixture<SharedBreadcrumbPresentational>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      imports: [RouterTestingModule, SolidifyFrontendModule],
      declarations: [SharedBreadcrumbPresentational, MockTranslatePipe],
      providers: [
        {
          provide: TranslateService,
          useClass: MockTranslateService,
        },
      ],
      schemas: [NO_ERRORS_SCHEMA],
    })
      .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(SharedBreadcrumbPresentational);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  xit("should create", () => {
    expect(component).toBeTruthy();
  });
});
