import {
  ChangeDetectionStrategy,
  Component,
  Input,
  OnInit,
  Output,
} from "@angular/core";
import {
  FormControl,
  NG_VALUE_ACCESSOR,
} from "@angular/forms";
import {SharedAbstractPresentational} from "@shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {
  BehaviorSubject,
  Observable,
} from "rxjs";
import {
  isNotNullNorUndefined,
  ObservableUtil,
} from "solidify-frontend";

@Component({
  selector: "dlcm-shared-archive-rating-star",
  templateUrl: "./shared-archive-rating-star.presentational.html",
  styleUrls: ["./shared-archive-rating-star.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
  providers: [
    {
      provide: NG_VALUE_ACCESSOR,
      multi: true,
      useExisting: SharedArchiveRatingStarPresentational,
    },
  ],
})
export class SharedArchiveRatingStarPresentational extends SharedAbstractPresentational implements OnInit {
  maxStarsNumber: number = 5;

  @Input()
  formControl: FormControl;

  @Input()
  value: number;

  @Input()
  numberReview: number | undefined = undefined;

  @Input()
  label: string;

  @Input()
  center: boolean = false;

  @Input()
  isEditable: boolean = false;

  private readonly _valueBS: BehaviorSubject<number | undefined> = new BehaviorSubject<number | undefined>(undefined);
  @Output("valueChange")
  readonly valueObs: Observable<number | undefined> = ObservableUtil.asObservable(this._valueBS);

  ngOnInit(): void {
    super.ngOnInit();
    if (isNotNullNorUndefined(this.formControl)) {
      this.value = this.formControl.value;
    }
  }

  propagateChange = (__: any) => {};

  registerOnChange(fn: any): void {
    this.propagateChange = fn;
  }

  registerOnTouched(fn: any): void {
  }

  writeValue(value: number): void {
  }

  hasBeenRated(): boolean {
    return this.value === 0;
  }

  rateChange(rate: number): void {
    this._valueBS.next(rate);
    this.formControl.setValue(rate);
    this.formControl.markAsDirty();
  }
}
