import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  Input,
} from "@angular/core";
import {Archive} from "@home/models/archive.model";
import {SharedAbstractPresentational} from "@shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {MetadataUtil} from "@shared/utils/metadata.util";
import {
  DateUtil,
  isNullOrUndefined,
  StringUtil,
} from "solidify-frontend";

@Component({
  selector: "dlcm-shared-archive-publication-date",
  templateUrl: "./shared-archive-publication-date.presentational.html",
  styleUrls: ["./shared-archive-publication-date.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class SharedArchivePublicationDatePresentational extends SharedAbstractPresentational {
  _archive: Archive;
  publicationDate: string;

  @Input()
  set archive(archive: Archive) {
    this._archive = archive;
    this.publicationDate = this._computePublicationDate();
  }

  constructor(private readonly _changeDetector: ChangeDetectorRef) {
    super();
  }

  private _computePublicationDate(): string {
    if (isNullOrUndefined(this._archive)) {
      return StringUtil.stringEmpty;
    }
    return DateUtil.convertDateToDateString(MetadataUtil.getIssuedDate(this._archive.archiveMetadata.metadata));
  }
}
