import {
  ChangeDetectionStrategy,
  Component,
  Input,
} from "@angular/core";
import {SharedAbstractPresentational} from "@app/shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {AipCopyList} from "@shared/models/business/aip-copy-list.model";
import {
  isEmptyArray,
  isNullOrUndefined,
} from "solidify-frontend";

@Component({
  selector: "dlcm-shared-aip-status-orgunit-name",
  templateUrl: "./shared-aip-status-orgunit-name.presentational.html",
  styleUrls: ["./shared-aip-status-orgunit-name.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class SharedAipStatusOrgunitNamePresentational extends SharedAbstractPresentational {
  private _aipCopyList: AipCopyList;

  @Input()
  set aipCopyList(value: AipCopyList) {
    this._aipCopyList = value;
    this.computeOrgUnitId();
  }

  get aipCopyList(): AipCopyList {
    return this._aipCopyList;
  }

  orgUnitId: string | undefined;

  private computeOrgUnitId(): void {
    if (isNullOrUndefined(this.aipCopyList) || isEmptyArray(this.aipCopyList)) {
      this.orgUnitId = undefined;
      return;
    }

    let copyWithDataProvided = undefined;
    this.aipCopyList.copies.some(copy => {
      if (!isNullOrUndefined(copy.aip)) {
        copyWithDataProvided = copy.aip;
        return true;
      }
    });

    if (isNullOrUndefined(copyWithDataProvided)) {
      this.orgUnitId = undefined;
      return;
    }
    this.orgUnitId = copyWithDataProvided.info.organizationalUnitId;
  }
}
