import {
  ChangeDetectionStrategy,
  Component,
  Input,
} from "@angular/core";
import {SharedAbstractPresentational} from "@app/shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {AipCopyList} from "@shared/models/business/aip-copy-list.model";
import {
  isEmptyArray,
  isNullOrUndefined,
} from "solidify-frontend";

@Component({
  selector: "dlcm-shared-aip-status-name",
  templateUrl: "./shared-aip-status-name.presentational.html",
  styleUrls: ["./shared-aip-status-name.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class SharedAipStatusNamePresentational extends SharedAbstractPresentational {
  private _aipCopyList: AipCopyList;

  @Input()
  set aipCopyList(value: AipCopyList) {
    this._aipCopyList = value;
    this.computeName();
  }

  get aipCopyList(): AipCopyList {
    return this._aipCopyList;
  }

  name: string | undefined;

  private computeName(): void {
    if (isNullOrUndefined(this.aipCopyList) || isEmptyArray(this.aipCopyList)) {
      this.name = undefined;
      return;
    }

    let copyWithDataProvided = undefined;
    this.aipCopyList.copies.some(copy => {
      if (!isNullOrUndefined(copy.aip)) {
        copyWithDataProvided = copy.aip;
        return true;
      }
    });

    if (isNullOrUndefined(copyWithDataProvided)) {
      this.name = undefined;
      return;
    }

    this.name = copyWithDataProvided.info.name;
  }
}
