import {
  ChangeDetectionStrategy,
  Component,
  Input,
} from "@angular/core";
import {FormBuilder} from "@angular/forms";
import {ResearchDomain} from "@models";
import {SharedAbstractPresentational} from "@shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {ResearchDomainLabel} from "@shared/models/business/research-domain-label.model";
import {isNullOrUndefined} from "solidify-frontend";

@Component({
  selector: "dlcm-shared-admin-research-domain-label",
  templateUrl: "./shared-admin-research-domain-label.presentational.html",
  styleUrls: ["./shared-admin-research-domain-label.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})

export class SharedAdminResearchDomainLabelPresentational extends SharedAbstractPresentational {
  private _researchDomain: ResearchDomain;

  private _language: string;

  @Input()
  set researchDomain(value: ResearchDomain) {
    this._researchDomain = value;
    this.computeLabel();
  }

  @Input()
  set language(value: string) {
    this._language = value;
    this.computeLabel();
  }

  get researchDomain(): ResearchDomain {
    return this._researchDomain;
  }

  get language(): string {
    return this._language;
  }

  value: ResearchDomainLabel | undefined;

  private computeLabel(): void {
    if (isNullOrUndefined(this.language) || isNullOrUndefined(this.researchDomain)) {
      return;
    }
    this.value = this.researchDomain.labels.find(label => label.language.resId === this.language);
    return;
  }

  constructor(public _fb: FormBuilder) {
    super();
  }
}
