import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  Input,
} from "@angular/core";
import {Enums} from "@enums";
import {SharedAbstractPresentational} from "@shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {IconNameEnum} from "@shared/enums/icon-name.enum";
import {EnumUtil} from "solidify-frontend";

@Component({
  selector: "dlcm-shared-access-level",
  templateUrl: "./shared-access-level.presentational.html",
  styleUrls: ["./shared-access-level.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class SharedAccessLevelPresentational extends SharedAbstractPresentational {
  _accessLevel: Enums.Deposit.AccessEnum;
  accessLevelIconName: IconNameEnum;
  labelToTranslate: string;

  @Input()
  set accessLevel(accessLevel: Enums.Deposit.AccessEnum) {
    this._accessLevel = accessLevel;
    this._computeAccessLevelIcon(accessLevel);
    this._computeLabel(accessLevel);
  }

  get accessLevel(): Enums.Deposit.AccessEnum {
    return this._accessLevel;
  }

  @Input()
  size: string = "xlg";

  @Input()
  withTooltip: boolean = false;

  constructor(private readonly _changeDetector: ChangeDetectorRef) {
    super();
  }

  private _computeAccessLevelIcon(accessLevel: Enums.Deposit.AccessEnum): void {
    switch (accessLevel) {
      case Enums.Deposit.AccessEnum.RESTRICTED:
        this.accessLevelIconName = IconNameEnum.accessLevelRestricted;
        break;
      case Enums.Deposit.AccessEnum.CLOSED:
        this.accessLevelIconName = IconNameEnum.accessLevelClosed;
        break;
      case Enums.Deposit.AccessEnum.PUBLIC:
        this.accessLevelIconName = IconNameEnum.accessLevelPublic;
        break;
      default:
        this.accessLevelIconName = IconNameEnum.accessLevelUndefined;
        break;
    }
  }

  private _computeLabel(accessLevel: Enums.Deposit.AccessEnum): void {
    this.labelToTranslate = EnumUtil.getLabel(Enums.Deposit.AccessEnumTranslate, accessLevel);
  }
}
