import {MatFormFieldAppearance} from "@angular/material/form-field";
import {environment} from "@environments/environment";
import {DataTestEnum} from "@shared/enums/data-test.enum";
import {IconNameEnum} from "@shared/enums/icon-name.enum";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {
  CoreAbstractComponent,
  EnumUtil,
} from "solidify-frontend";

export class SharedAbstractPresentational extends CoreAbstractComponent {
  get iconNameEnum(): typeof IconNameEnum {
    return IconNameEnum;
  }

  get dataTestEnum(): typeof DataTestEnum {
    return DataTestEnum;
  }

  get labelTranslateEnum(): typeof LabelTranslateEnum {
    return LabelTranslateEnum;
  }

  get enumUtil(): typeof EnumUtil {
    return EnumUtil;
  }

  get appearanceInputMaterial(): MatFormFieldAppearance {
    return environment.appearanceInputMaterial;
  }
}
