import {
  AfterViewInit,
  Directive,
  HostListener,
  Input,
  OnInit,
  Output,
} from "@angular/core";
import {SharedAbstractPresentational} from "@app/shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {
  BehaviorSubject,
  Observable,
} from "rxjs";
import {
  BaseResourceType,
  isEmptyString,
  isNullOrUndefined,
  ObservableUtil,
} from "solidify-frontend";

@Directive()
export abstract class SharedAbstractContentPresentational<TResource extends BaseResourceType> extends SharedAbstractPresentational implements OnInit, AfterViewInit {
  @Input()
  abstract host: any;

  private readonly _closeBS: BehaviorSubject<void> = new BehaviorSubject<void>(undefined);
  @Output("closeChange")
  readonly closeObs: Observable<void> = ObservableUtil.asObservable(this._closeBS);

  private readonly _closeByTabBS: BehaviorSubject<void> = new BehaviorSubject<void>(undefined);
  @Output("closeByTabChange")
  readonly closeByTabObs: Observable<void> = ObservableUtil.asObservable(this._closeByTabBS);

  private readonly _closeByShiftTabBS: BehaviorSubject<void> = new BehaviorSubject<void>(undefined);
  @Output("closeByShiftTabChange")
  readonly closeByShiftTabObs: Observable<void> = ObservableUtil.asObservable(this._closeByShiftTabBS);

  indexSelected: number;

  constructor() {
    super();
  }

  closeByTab(keyEvent: KeyboardEvent): void {
    if (!keyEvent.defaultPrevented) {
      keyEvent.preventDefault();
      this._closeByTabBS.next();
    }
  }

  closeByShiftTab(keyEvent: KeyboardEvent): void {
    if (!keyEvent.defaultPrevented) {
      keyEvent.preventDefault();
      this._closeByShiftTabBS.next();
    }
  }

  ngOnInit(): void {
    super.ngOnInit();
  }

  abstract select(value: TResource): void;

  close(): void {
    this._closeBS.next();
  }

  isActive(value: TResource): boolean {
    if (isNullOrUndefined(value) || isNullOrUndefined(this.host.formControl.value) || isEmptyString(this.host.formControl.value)) {
      return false;
    }
    return this.host.formControl.value.includes(value[this.host.valueKey]);
  }

  selectNextResource(): void {
    const val = this.host.list;
    let activeValIndex = -1;
    for (let index = 0; index < val.length; index++) {
      if (this.indexSelected === index) {
        activeValIndex = index;
        break;
      }
    }
    if (activeValIndex !== val.length - 1) {
      this.indexSelected = activeValIndex + 1;
    } else {
      this.indexSelected = activeValIndex;
    }
  }

  selectPreviousResource(): void {
    const val = this.host.list;
    let activeValIndex = -1;
    for (let index = 0; index < val.length; index++) {
      if (this.indexSelected === index) {
        activeValIndex = index;
        break;
      }
    }
    if (activeValIndex > 0) {
      this.indexSelected = activeValIndex - 1;
    } else {
      this.indexSelected = activeValIndex;
    }
  }

  @HostListener("keydown.arrowDown", ["$event"])
  onArrowDown(keyboardEvent: KeyboardEvent): void {
    if (keyboardEvent && !keyboardEvent.defaultPrevented) {
      keyboardEvent.preventDefault();
      this.selectNextResource();
    }
  }

  @HostListener("keydown.arrowUp", ["$event"])
  onArrowUp(keyboardEvent: KeyboardEvent): void {
    if (keyboardEvent && !keyboardEvent.defaultPrevented) {
      keyboardEvent.preventDefault();
      this.selectPreviousResource();
    }
  }

}



