import {
  Directive,
  ElementRef,
  Input,
  OnInit,
  Output,
  ViewChild,
} from "@angular/core";
import {Navigate} from "@ngxs/router-plugin";
import {SharedAbstractPresentational} from "@shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {ExtraButtonToolbar} from "@shared/models/extra-button-toolbar.model";
import {
  BehaviorSubject,
  Observable,
} from "rxjs";
import {
  BaseResource,
  isNotNullNorUndefined,
  isTruthyObject,
  ObservableUtil,
} from "solidify-frontend";

@Directive()
export abstract class SharedAbstractButtonToolbarPresentational<TResourceModel extends BaseResource> extends SharedAbstractPresentational implements OnInit {
  @Input()
  readonly keyBackButtonToTranslate: string = LabelTranslateEnum.backToList;

  @Input()
  isLoading: boolean;

  _listExtraButtons?: ExtraButtonToolbar<TResourceModel>[];

  @Input()
  set listExtraButtons(value: ExtraButtonToolbar<TResourceModel>[]) {
    this._listExtraButtons = value;
    this._mergeExtraButtonWithButtons();
  }

  get listExtraButtons(): ExtraButtonToolbar<TResourceModel>[] {
    return this._listExtraButtons;
  }

  @Input()
  listExtraSmallButtons?: ExtraButtonToolbar<TResourceModel>[];

  listOriginalButton?: ExtraButtonToolbar<TResourceModel>[];
  listButtonMerged?: ExtraButtonToolbar<TResourceModel>[];

  private readonly _backToListBS: BehaviorSubject<void> = new BehaviorSubject<void>(undefined);
  @Output("backToListChange")
  readonly backToListObs: Observable<void> = ObservableUtil.asObservable(this._backToListBS);

  private readonly _navigateBS: BehaviorSubject<Navigate> = new BehaviorSubject<Navigate>(undefined);
  @Output("navigateChange")
  readonly navigateObs: Observable<Navigate> = ObservableUtil.asObservable(this._navigateBS);

  @ViewChild("mainButtonElement", {static: true})
  mainButtonElement: ElementRef;

  constructor() {
    super();
  }

  focusFirstButtonElement(): void {
    setTimeout(() => {
      if (isTruthyObject(this.mainButtonElement)) {
        this.mainButtonElement.nativeElement.querySelectorAll("*").forEach((elementToFocus: HTMLElement) => {
            elementToFocus.focus();
          },
        );
      }
    });
  }

  ngOnInit(): void {
    super.ngOnInit();
    this._mergeExtraButtonWithButtons();
  }

  private _mergeExtraButtonWithButtons(): void {
    const originalButtons = isNotNullNorUndefined(this.listOriginalButton) ? this.listOriginalButton : [];
    const extraButtons = isNotNullNorUndefined(this.listExtraButtons) ? this._listExtraButtons : [];
    this.listButtonMerged = [...originalButtons, ...extraButtons];
    this.listButtonMerged.sort((a, b) => {
      const orderA = a.order || 0;
      const orderB = b.order || 0;
      if (orderA === orderB) {
        return 0;
      } else if (orderA < orderB) {
        return -1;
      }
      return 1;
    });
  }

  backToList(): void {
    this._backToListBS.next();
  }

  navigate(navigate: Navigate): void {
    this._navigateBS.next(navigate);
  }
}
