import {
  ChangeDetectionStrategy,
  Component,
  Inject,
} from "@angular/core";
import {
  MAT_DIALOG_DATA,
  MatDialogRef,
} from "@angular/material/dialog";
import {
  Actions,
  Store,
} from "@ngxs/store";
import {SharedAbstractContainer} from "@shared/components/containers/shared-abstract/shared-abstract.container";
import {ImageCroppedEvent} from "ngx-image-cropper";
import {Observable} from "rxjs";
import {
  MARK_AS_TRANSLATABLE,
  NotificationService,
} from "solidify-frontend";

@Component({
  selector: "dlcm-shared-upload-image-dialog",
  templateUrl: "./shared-upload-image.dialog.html",
  styleUrls: ["./shared-upload-image.dialog.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class SharedUploadImageDialog extends SharedAbstractContainer {
  isLoadingCropper: boolean = true;
  isLoadingImage: boolean = true;

  constructor(protected _store: Store,
              protected dialogRef: MatDialogRef<SharedUploadImageDialog>,
              private readonly _actions$: Actions,
              private readonly _notificationService: NotificationService,
              @Inject(MAT_DIALOG_DATA) public data: SharedUploadImageDialogData) {
    super();
  }

  close(): void {
    this.dialogRef.close();
  }

  croppedImage: any = "";

  imageCropped(event: ImageCroppedEvent): void {
    this.croppedImage = event.base64;
  }

  imageLoaded(): void {
    this.isLoadingImage = false;
    // show cropper
  }

  cropperReady(): void {
    this.isLoadingCropper = false;
    // cropper ready
  }

  loadImageFailed(): void {
    // show message
    this._notificationService.showError(MARK_AS_TRANSLATABLE("uploadImage.notSupported"));
  }

  confirm(): void {
    const blob = this.base64toBlob(this.croppedImage);
    const fileList: FileList = this.data.imageChangedEvent.target.files;
    blob["name"] = fileList.item(0).name;
    this.dialogRef.close(blob);
  }

  base64toBlob(dataURI: string): Blob {
    const dataURISplitted = dataURI.split(",");
    const firstPart = dataURISplitted[0];
    const contentTypeData = firstPart.split(";")[0].split(":")[1];
    const byteString = atob(dataURISplitted[1]);
    const ab = new ArrayBuffer(byteString.length);
    const ia = new Uint8Array(ab);

    for (let i = 0; i < byteString.length; i++) {
      ia[i] = byteString.charCodeAt(i);
    }
    return new Blob([ab], {type: contentTypeData});
  }
}

export interface SharedUploadImageDialogData {
  titleToTranslate: string;
  imageChangedEvent: any;
  isLoadingObs: Observable<boolean>;
  aspectRatio: number;
  roundCropped: boolean;
  resizeToWidth: number;
  resizeToHeight: number;
}
