import {
  ChangeDetectionStrategy,
  Component,
  Inject,
} from "@angular/core";
import {
  MAT_DIALOG_DATA,
  MatDialogRef,
} from "@angular/material/dialog";
import {SharedAbstractContainer} from "@shared/components/containers/shared-abstract/shared-abstract.container";
import {SharedPreviewDialogData} from "@shared/components/dialogs/shared-preview/shared-preview-dialog-data.model";

@Component({
  selector: "dlcm-shared-preview-dialog",
  templateUrl: "./shared-preview.dialog.html",
  styleUrls: ["./shared-preview.dialog.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class SharedPreviewDialog extends SharedAbstractContainer {

  constructor(@Inject(MAT_DIALOG_DATA) public data: SharedPreviewDialogData,
              public dialogRef: MatDialogRef<SharedPreviewDialog>) {
    super();
  }

  onClosePopup(needToClosePopup: boolean): void {
    this.dialogRef.close();
  }

}
