import {
  ChangeDetectionStrategy,
  Component,
  Inject,
  OnInit,
} from "@angular/core";
import {
  MAT_DIALOG_DATA,
  MatDialogRef,
} from "@angular/material/dialog";
import {DepositState} from "@deposit/stores/deposit.state";
import {Enums} from "@enums";
import {environment} from "@environments/environment";
import {Store} from "@ngxs/store";
import {SharedAbstractContainer} from "@shared/components/containers/shared-abstract/shared-abstract.container";
import {FileListModel} from "@shared/models/business/file-list.model";
import {Observable} from "rxjs";
import {
  MARK_AS_TRANSLATABLE,
  MemoizedUtil,
} from "solidify-frontend";

@Component({
  selector: "dlcm-shared-info-excluded-ignored-file-dialog",
  templateUrl: "./shared-info-excluded-ignored-file.dialog.html",
  styleUrls: ["./shared-info-excluded-ignored-file.dialog.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class SharedInfoExcludedIgnoredFileDialog extends SharedAbstractContainer implements OnInit {
  fileListObs: Observable<FileListModel>;

  titleToTranslate: string = "";
  messageToTranslate: string = "";

  constructor(private readonly _store: Store,
              protected dialogRef: MatDialogRef<SharedInfoExcludedIgnoredFileDialog>,
              @Inject(MAT_DIALOG_DATA) public data: SharedInfoExcludedIgnoredFileDialogData) {
    super();
  }

  ngOnInit(): void {
    super.ngOnInit();

    if (this.data.dataFileStatusEnum === Enums.DataFile.StatusEnum.IGNORED_FILE) {
      this.fileListObs = MemoizedUtil.select(this._store, DepositState, state => state.ignoredFileList);
      this.titleToTranslate = MARK_AS_TRANSLATABLE("deposit.file.dialog.excludedIgnoredFile.title.ignored");
      this.messageToTranslate = MARK_AS_TRANSLATABLE("deposit.file.dialog.excludedIgnoredFile.message.ignored");
    } else if (this.data.dataFileStatusEnum === Enums.DataFile.StatusEnum.EXCLUDED_FILE) {
      this.fileListObs = MemoizedUtil.select(this._store, DepositState, state => state.excludedFileList);
      this.titleToTranslate = MARK_AS_TRANSLATABLE("deposit.file.dialog.excludedIgnoredFile.title.excluded");
      this.messageToTranslate = MARK_AS_TRANSLATABLE("deposit.file.dialog.excludedIgnoredFile.message.excluded");
    } else {
      this.dialogRef.close();
    }
  }

  getPuidLink(puid: string): string {
    return environment.urlNationalArchivePronom + puid;
  }
}

export interface SharedInfoExcludedIgnoredFileDialogData {
  dataFileStatusEnum: Enums.DataFile.StatusEnum;
}
