import {
  Component,
  Inject,
  OnInit,
} from "@angular/core";
import {MAT_DIALOG_DATA} from "@angular/material/dialog";
import {Enums} from "@enums";
import {TranslateService} from "@ngx-translate/core";
import {Store} from "@ngxs/store";
import {SharedAbstractContainer} from "@shared/components/containers/shared-abstract/shared-abstract.container";
import {DataTableComponentEnum} from "@shared/enums/data-table-component.enum";
import {FieldTypeEnum} from "@shared/enums/field-type.enum";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {DataTableColumns} from "@shared/models/data-table-columns.model";
import {StatusHistoryDialog} from "@shared/models/status-history-dialog.model";
import {
  OrderEnum,
  QueryParameters,
  StringUtil,
} from "solidify-frontend";

@Component({
  selector: "dlcm-shared-history-dialog",
  templateUrl: "./shared-history.dialog.html",
  styleUrls: ["./shared-history.dialog.scss"],
})
export class SharedHistoryDialog extends SharedAbstractContainer implements OnInit {
  paramMessage: { name: string } = {name: ""};
  columns: DataTableColumns[];

  constructor(private translate: TranslateService,
              private store: Store,
              @Inject(MAT_DIALOG_DATA) public data: StatusHistoryDialog) {
    super();
    this.paramMessage.name = StringUtil.convertToPascalCase(this.data.name);
  }

  ngOnInit(): void {
    super.ngOnInit();
    this.columns = [
      {
        field: "changeTime",
        header: LabelTranslateEnum.changeTime,
        type: FieldTypeEnum.datetime,
        order: OrderEnum.descending,
        isSortable: true,
        isFilterable: false,
      },
      {
        field: "status",
        header: LabelTranslateEnum.status,
        type: FieldTypeEnum.singleSelect,
        order: OrderEnum.none,
        isSortable: false,
        isFilterable: false,
        filterEnum: Enums.History.StatusEnumTranslate,
        translate: true,
        width: "110px",
        component: DataTableComponentEnum.status,
      },
      {
        field: "description",
        header: LabelTranslateEnum.description,
        type: FieldTypeEnum.number,
        order: OrderEnum.none,
        isSortable: true,
        isFilterable: false,
      },
      {
        field: "creatorName",
        header: LabelTranslateEnum.createdBy,
        type: FieldTypeEnum.string,
        order: OrderEnum.none,
        isSortable: false,
        isFilterable: false,
        width: "140px",
      },
    ];
  }

  pagination($event: QueryParameters): void {
    this.store.dispatch(new this.data.state.ChangeQueryParameters($event, this.data.resourceResId, this.data.parentId));
  }
}
