import {
  ChangeDetectionStrategy,
  Component,
  Inject,
  OnInit,
} from "@angular/core";
import {
  MAT_DIALOG_DATA,
  MatDialogRef,
} from "@angular/material/dialog";
import {SharedBaseActionDialog} from "@shared/components/dialogs/shared-base-action/shared-base-action.dialog";

@Component({
  selector: "dlcm-shared-data-table-loose-selection-dialog",
  templateUrl: "./shared-data-table-loose-selection.dialog.html",
  styleUrls: ["./shared-data-table-loose-selection.dialog.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class SharedDataTableLooseSelectionDialog extends SharedBaseActionDialog implements OnInit {
  paramMessage: { numberSelected: number } = {numberSelected: 0};

  constructor(private readonly _dialogRef: MatDialogRef<SharedDataTableLooseSelectionDialog>,
              @Inject(MAT_DIALOG_DATA) public data: SharedDataTableLooseSelectionDialogData) {
    super();
  }

  ngOnInit(): void {
    super.ngOnInit();
    this.paramMessage.numberSelected = this.data.numberItemSelected;
  }

  confirm(): void {
    this._dialogRef.close(true);
  }
}

export interface SharedDataTableLooseSelectionDialogData {
  numberItemSelected: number;
}
