import {
  ChangeDetectionStrategy,
  Component,
  Inject,
  OnInit,
} from "@angular/core";
import {
  MAT_DIALOG_DATA,
  MatDialogRef,
} from "@angular/material/dialog";
import {SharedAbstractContainer} from "@app/shared/components/containers/shared-abstract/shared-abstract.container";
import {isNullOrUndefined} from "solidify-frontend";

@Component({
  selector: "dlcm-shared-confirm-dialog",
  templateUrl: "./shared-confirm.dialog.html",
  styleUrls: ["./shared-confirm.dialog.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class SharedConfirmDialog extends SharedAbstractContainer implements OnInit {
  constructor(private dialogRef: MatDialogRef<SharedConfirmDialog>,
              @Inject(MAT_DIALOG_DATA) public data: SharedConfirmDialogData) {
    super();
  }

  get colorConfirm(): string {
    return isNullOrUndefined(this.data.colorConfirm) ? "primary" : this.data.colorConfirm;
  }

  confirm(): void {
    this.dialogRef.close(true);
  }
}

export interface SharedConfirmDialogData {
  titleToTranslate: string;
  paramTitle?: Object | undefined;
  messageToTranslate: string;
  paramMessage?: Object | undefined;
  confirmButtonToTranslate: string;
  cancelButtonToTranslate: string;
  colorConfirm?: string;
}
