import {
  ChangeDetectionStrategy,
  Component,
  Inject,
  OnInit,
} from "@angular/core";
import {
  MAT_DIALOG_DATA,
  MatDialogRef,
} from "@angular/material/dialog";
import {Store} from "@ngxs/store";
import {SharedAbstractDialog} from "@shared/components/dialogs/shared-abstract/shared-abstract.dialog";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {
  isNotNullNorUndefined,
  ResourceActionHelper,
  ResourceNameSpace,
} from "solidify-frontend";

@Component({
  selector: "dlcm-delete-dialog",
  templateUrl: "./shared-delete.dialog.html",
  styleUrls: ["./shared-delete.dialog.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class SharedDeleteDialog extends SharedAbstractDialog implements OnInit {
  paramMessage: { name: string } = {name: ""};

  public readonly KEY_TITLE: string = LabelTranslateEnum.confirmDeleteAction;
  public readonly KEY_CONFIRM_BUTTON: string = LabelTranslateEnum.yes;
  public readonly KEY_CANCEL_BUTTON: string = LabelTranslateEnum.cancel;

  constructor(private _store: Store,
              private _dialogRef: MatDialogRef<SharedDeleteDialog>,
              @Inject(MAT_DIALOG_DATA) public data: SharedDeleteDialogData) {
    super();
  }

  ngOnInit(): void {
    super.ngOnInit();
    this.paramMessage.name = this.data.name;
  }

  confirm(): void {
    if (isNotNullNorUndefined(this.data.resId)) {
      this._store.dispatch(ResourceActionHelper.delete(this.data.resourceNameSpace, this.data.resId));
    }
    this._dialogRef.close(true);
  }
}

export interface SharedDeleteDialogData {
  resId?: string;
  name: string;
  message: string;
  resourceNameSpace: ResourceNameSpace;
}
