import {
  ChangeDetectionStrategy,
  Component,
  Input,
} from "@angular/core";
import {Enums} from "@enums";
import {OrganizationalUnit} from "@models";
import {SharedAbstractPresentational} from "@shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {IconNameEnum} from "@shared/enums/icon-name.enum";
import {SecurityService} from "@shared/services/security.service";
import {isNullOrUndefined} from "solidify-frontend";

@Component({
  selector: "dlcm-shared-organizational-unit-member-container",
  templateUrl: "./shared-organizational-unit-member.container.html",
  styleUrls: ["./shared-organizational-unit-member.container.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})

export class SharedOrganizationalUnitMemberContainer extends SharedAbstractPresentational {
  private _organizationalUnit: OrganizationalUnit;

  iconMember: IconNameEnum | undefined = undefined;
  roleName: string | undefined = undefined;

  @Input()
  set organizationalUnit(value: OrganizationalUnit) {
    this._organizationalUnit = value;
    this.computeLogoAndTootlip();
  }

  get organizationalUnit(): OrganizationalUnit {
    return this._organizationalUnit;
  }

  private computeLogoAndTootlip(): void {
    if (isNullOrUndefined(this.organizationalUnit)) {
      return;
    }
    const role = this._securityService.getRoleInOrgUnit(this.organizationalUnit.resId);
    this.roleName = role?.name;
    switch (role?.resId) {
      case Enums.Role.RoleEnum.MANAGER:
        this.iconMember = IconNameEnum.roleManager;
        break;
      case Enums.Role.RoleEnum.STEWARD:
        this.iconMember = IconNameEnum.roleSteward;
        break;
      case Enums.Role.RoleEnum.APPROVER:
        this.iconMember = IconNameEnum.roleApprover;
        break;
      case Enums.Role.RoleEnum.CREATOR:
        this.iconMember = IconNameEnum.roleCreator;
        break;
      case Enums.Role.RoleEnum.VISITOR:
        this.iconMember = IconNameEnum.roleVisitor;
        break;
      default:
        this.iconMember = undefined;
        break;
    }
  }

  constructor(public _securityService: SecurityService) {
    super();
  }
}
