import {AdminOrganizationalUnitState} from "@admin/organizational-unit/stores/admin-organizational-unit.state";
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  Input,
} from "@angular/core";
import {FormBuilder} from "@angular/forms";
import {MatDialog} from "@angular/material/dialog";
import {DomSanitizer} from "@angular/platform-browser";
import {ActivatedRoute} from "@angular/router";
import {environment} from "@environments/environment";
import {
  Actions,
  Store,
} from "@ngxs/store";
import {SharedAbstractImageUploadWrapperContainer} from "@shared/components/containers/shared-abstract-image-upload-wrapper/shared-abstract-image-upload-wrapper.container";
import {SharedUploadImageDialogData} from "@shared/components/dialogs/shared-upload-image/shared-upload-image.dialog";
import {IconNameEnum} from "@shared/enums/icon-name.enum";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {OverrideProperty} from "solidify-frontend";

@Component({
  selector: "dlcm-shared-image-upload-wrapper-container",
  templateUrl: "./shared-image-upload-wrapper.container.html",
  styleUrls: ["./shared-image-upload-wrapper.container.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class SharedImageUploadWrapperContainer extends SharedAbstractImageUploadWrapperContainer {
  @Input()
  isEditable: boolean = true;

  @OverrideProperty()
  @Input()
  resourceLogoState: typeof AdminOrganizationalUnitState;

  @Input()
  preFallbackImage: string | undefined;

  defaultImage: string = `assets/themes/${environment.theme}/toolbar-header-image.svg`;

  @Input()
  defaultIcon: IconNameEnum;

  constructor(protected readonly _store: Store,
              protected readonly _route: ActivatedRoute,
              protected readonly _fb: FormBuilder,
              protected readonly _sanitizer: DomSanitizer,
              protected readonly _cd: ChangeDetectorRef,
              protected readonly _actions$: Actions,
              protected readonly _dialog: MatDialog) {
    super(_store,
      _route,
      _fb,
      _sanitizer,
      _cd,
      _actions$,
      _dialog);
  }

  openModal(): void {
    if (!this.isEditable) {
      return;
    }
    super.openModal();
  }

  protected _defineSharedImageDialogData(): SharedUploadImageDialogData {
    return {
      titleToTranslate: LabelTranslateEnum.uploadLogo,
      imageChangedEvent: undefined,
      isLoadingObs: this.isLoadingObs,
      aspectRatio: 1,
      roundCropped: false,
      resizeToHeight: 300 * 2,
      resizeToWidth: 300 * 2,
    };
  }
}
