/* tslint:disable:import-blacklist */
import {Enums} from "@app/enums";
import {ArchiveMetadata} from "@app/shared/models/business/archive-metadata.model";
import {Tool} from "@deposit/models/tool.model";
import {BaseResource} from "solidify-frontend";
import {AccessOrganizationalUnit as AccessOrganizationalUnitPartial} from "../generated-api/model/access-organizational-unit.partial.model";
import {Access as AccessPartial} from "../generated-api/model/access.partial.model";
import {Admin as AdminPartial} from "../generated-api/model/admin.partial.model";
import {AipChecksumCheck as AipChecksumCheckPartial} from "../generated-api/model/aip-checksum-check.partial.model";
import {AipFileFormat as AipFileFormatPartial} from "../generated-api/model/aip-file-format.partial.model";
import {AipInfoEmbargo as AipInfoEmbargoPartial} from "../generated-api/model/aip-info-embargo.partial.model";
import {AipInfo as AipInfoPartial} from "../generated-api/model/aip-info.partial.model";
import {AipVirusCheck as AipVirusCheckPartial} from "../generated-api/model/aip-virus-check.partial.model";
import {Aip as AipPartial} from "../generated-api/model/aip.partial.model";
import {ApplicationRole as ApplicationRolePartial} from "../generated-api/model/application-role.partial.model";
import {Application as ApplicationPartial} from "../generated-api/model/application.partial.model";
import {ArchivalStorage as ArchivalStoragePartial} from "../generated-api/model/archival-storage.partial.model";
import {ArchiveStatistics as ArchiveStatisticPartial} from "../generated-api/model/archive-statistics.partial.model";
import {ChangeInfo as ChangeInfoPartial} from "../generated-api/model/change-info.partial.model";
import {Collection as CollectionPartial} from "../generated-api/model/collection.partial.model";
import {Contributor as ContributorPartial} from "../generated-api/model/contributor.partial.model";
import {DataMgmt as DataMgmtPartial} from "../generated-api/model/data-mgmt.partial.model";
import {Deposit as DepositPartial} from "../generated-api/model/deposit.partial.model";
import {Dip as DipPartial} from "../generated-api/model/dip.partial.model";
import {DisseminationPolicy as DisseminationPolicyPartial} from "../generated-api/model/dissemination-policy.partial.model";
import {FundingAgency as FundingAgencyPartial} from "../generated-api/model/funding-agency.partial.model";
import {Ingest as IngestPartial} from "../generated-api/model/ingest.partial.model";
import {Institution as InstitutionPartial} from "../generated-api/model/institution.partial.model";
import {Language as LanguagePartial} from "../generated-api/model/language.partial.model";
import {License as LicensePartial} from "../generated-api/model/license.partial.model";
import {MetadataType as MetadataTypePartial} from "../generated-api/model/metadata-type.partial.model";
import {Metadata as MetadataPartial} from "../generated-api/model/metadata.partial.model";
import {Notification as NotificationPartial} from "../generated-api/model/notification.partial.model";
import {OaiSet as OaiSetPartial} from "../generated-api/model/oai-set.partial.model";
import {Oauth2Client as Oauth2ClientPartial} from "../generated-api/model/oauth2-client.partial.model";
import {Order as OrderPartial} from "../generated-api/model/order.partial.model";
import {OrganizationalUnit as OrganizationalUnitPartial} from "../generated-api/model/organizational-unit.partial.model";
import {Page as PagePartial} from "../generated-api/model/page.partial.model";
import {Person as PersonPartial} from "../generated-api/model/person.partial.model";
import {Preingest as PreingestPartial} from "../generated-api/model/preingest.partial.model";
import {PreservationJobScheduling as PreservationJobSchedulingPartial} from "../generated-api/model/preservation-job-scheduling.partial.model";
import {PreservationJob as PreservationJobPartial} from "../generated-api/model/preservation-job.partial.model";
import {PreservationPlanning as PreservationPlanningPartial} from "../generated-api/model/preservation-planning.partial.model";
import {PreservationPolicy as PreservationPolicyPartial} from "../generated-api/model/preservation-policy.partial.model";
import {ResearchDomain as ResearchDomainPartial} from "../generated-api/model/research-domain.partial.model";
import {Role as RolePartial} from "../generated-api/model/role.partial.model";
import {Sip as SipPartial} from "../generated-api/model/sip.partial.model";
import {SubmissionAgreement as SubmissionAgreementPartial} from "../generated-api/model/submission-agreement.partial.model";
import {SubmissionPolicy as SubmissionPolicyPartial} from "../generated-api/model/submission-policy.partial.model";
import {SystemProperty as SystemPropertyPartial} from "../generated-api/model/system-property.partial.model";
import {User as UserPartial} from "../generated-api/model/user.partial.model";
import RatingTypeEnum = Enums.Archive.RatingTypeEnum;

export interface AccessOrganizationalUnit extends AccessOrganizationalUnitPartial, BaseResource {
}

export interface Access extends AccessPartial {
}

export interface Admin extends AdminPartial {
}

export interface AipChecksumCheck extends AipChecksumCheckPartial {
  details?: string;
  tool?: Tool;
}

export interface AipFileFormat extends AipFileFormatPartial {
  tool?: Tool;
}

export interface AipInfoEmbargo extends AipInfoEmbargoPartial {
}

export interface AipInfo extends AipInfoPartial {
}

export interface Aip extends AipPartial, BaseResource {
  organizationalUnit?: string;
  fileFormat?: AipFileFormat;
  virusCheck?: AipChecksumCheck;
}

export interface AipVirusCheck extends AipVirusCheckPartial {
}

export interface Application extends ApplicationPartial {
}

export interface ApplicationRole extends ApplicationRolePartial, BaseResource {
}

export interface ArchivalStorage extends ArchivalStoragePartial {
}

export interface ArchiveACL extends BaseResource {
  aipId?: string;
  organizationalUnit?: OrganizationalUnit;
  user?: User;
  expiration?: any;
  expired?: boolean;
}

export interface ArchiveStatistic extends ArchiveStatisticPartial, BaseResource {
}

export interface ArchiveUserRating extends BaseResource {
  archiveId?: string;
  user?: User;
  ratingType?: RatingType;
  grade?: string;
}

export interface ChangeInfo extends ChangeInfoPartial {
}

export interface Collection extends CollectionPartial {
}

export interface Contributor extends ContributorPartial, BaseResource {
}

export interface AdditionalFieldsForm {
  resId?: string;
  type?: Enums.FormDescription.TypeEnum;
  name?: string;
  description?: string;
  creation?: ChangeInfo;
  lastUpdate?: ChangeInfo;
}

export interface DataMgmt extends DataMgmtPartial {
}

export interface Deposit extends DepositPartial, BaseResource {
  organizationalUnit?: OrganizationalUnit;
  language?: Language;
  preservationPolicy?: PreservationPolicy;
  submissionPolicy?: SubmissionPolicy;
  collectionBegin?: any;
  collectionEnd?: any;
  additionalFieldsValues?: string;
}

export interface Dip extends DipPartial, BaseResource {
}

export interface DisseminationPolicy extends DisseminationPolicyPartial, BaseResource {
}

export interface DownloadToken extends BaseResource {
  user: User;
  archiveId: string;
  token: string;
}

export interface FundingAgency extends FundingAgencyPartial, BaseResource {
  organizationalUnits?: OrganizationalUnit[];
}

export interface IndexFieldAlias extends BaseResource {
  indexName?: string;
  alias?: string;
  field?: string;
  facet?: boolean;
  facetMinCount?: number;
  facetLimit?: number;
  facetOrder?: number;
  facetDefaultVisibleValues?: number;
  labels: Label[];
}

export interface Ingest extends IngestPartial {
}

export interface Institution extends InstitutionPartial, BaseResource {
  logo?: Logo;
}

export interface Language extends LanguagePartial, BaseResource {
}

export interface License extends LicensePartial, BaseResource {
}

export interface Logo {
  resId?: string;
  fileName?: string;
  fileSize?: number;
  creation?: ChangeInfo;
  lastUpdate?: ChangeInfo;
}

export interface MetadataType extends MetadataTypePartial, BaseResource {
}

export interface Metadata extends MetadataPartial {
  metadata: ArchiveMetadata.PublicMetadata;
}

export interface NotificationDlcm extends NotificationPartial, BaseResource {
  specification?: object;
  notificationType?: NotificationTypeDlcm;
  notificationStatus?: Enums.Notification.StatusEnum;
  managedBy?: object;
  notifiedOrgUnit?: OrganizationalUnit;
  objectId?: string;
  emitter?: User;
  message?: string;
  creation?: ChangeInfo;
  lastUpdate?: ChangeInfo;
}

export interface NotificationTypeDlcm extends NotificationPartial, BaseResource {
  resId?: Enums.Notification.TypeEnum;
  notificationCategory?: Enums.Notification.CategoryEnum;
  notifiedOrgUnitRole?: Role;
  notifiedApplicationRole?: ApplicationRole;
  creation?: ChangeInfo;
  lastUpdate?: ChangeInfo;
}

export interface OaiSet extends OaiSetPartial, BaseResource {
  organizationalUnits?: OrganizationalUnit[];
}

export interface Oauth2Client extends Oauth2ClientPartial, BaseResource {
  secret?: string;
}

export interface Order extends OrderPartial, BaseResource {
}

export interface OrganizationalUnit extends OrganizationalUnitPartial, BaseResource {
  defaultSubmissionPolicy?: SubmissionPolicy;
  defaultPreservationPolicy?: PreservationPolicy;
  defaultDisseminationPolicy?: DisseminationPolicy;
  submissionPolicies?: SubmissionPolicy[];
  preservationPolicies?: PreservationPolicy[];
  disseminationPolicies?: DisseminationPolicy[];
  fundingAgencies?: FundingAgency[];
  institutions?: Institution[];
  researchDomains?: ResearchDomain[];
  keywords?: string[];
  defaultLicense?: License;
  role?: Role | null;
  logo?: Logo;
}

export interface Page extends PagePartial {
}

export interface Person extends PersonPartial, BaseResource {
  organizationalUnits?: AccessOrganizationalUnit[];
  institutions?: Institution[];
  hasAuthenticatedOrcid?: boolean;
}

export interface Preingest extends PreingestPartial {
}

export interface PreservationJob extends PreservationJobPartial, BaseResource {
  scheduling?: PreservationJobScheduling;
  lastExecutionStatus?: Enums.PreservationJob.ExecutionStatusEnum;
}

export interface PreservationPlanning extends PreservationPlanningPartial {
}

export interface PreservationPolicy extends PreservationPolicyPartial, BaseResource {
}

export interface PreservationJobScheduling extends PreservationJobSchedulingPartial, BaseResource {
  weekDay?: string;
}

export interface RatingType extends BaseResource {
  resId?: RatingTypeEnum;
  name?: string;
  creation?: ChangeInfo;
  lastUpdate?: ChangeInfo;
}

export interface ResearchDomain extends ResearchDomainPartial, BaseResource {
  labels?: any[];
}

export interface Role extends RolePartial, BaseResource {
}

export interface Sip extends SipPartial, BaseResource {
  organizationalUnit?: OrganizationalUnit;
}

export interface SubmissionAgreement extends SubmissionAgreementPartial, BaseResource {
}

export interface SubmissionPolicy extends SubmissionPolicyPartial, BaseResource {
}

export interface SystemProperty extends SystemPropertyPartial, BaseResource {
  searchFacets: FacetProperty[] | any;
  orcidClientId: string;
}

export interface User extends UserPartial, BaseResource {
  person?: Person;
  accessToken?: string;
  refreshToken?: string;
  applicationRole?: ApplicationRole;
  lastLoginIpAddress?: string;
  lastLoginTime?: string;
  avatar?: Logo;
}

export interface SearchFacet {
  field: string;
  equalValue: string | string[];
  type: undefined | "NOT_MATCH";
}

export interface FacetProperty {
  name: string;
  defaultVisibleValues: number;
  labels: Label[];
}

export interface Label {
  language: Language;
  text: string;
}
