import {A11yModule} from "@angular/cdk/a11y";
import {OverlayModule} from "@angular/cdk/overlay";
import {PortalModule} from "@angular/cdk/portal";
import {NgModule} from "@angular/core";
import {MatMomentDateModule} from "@angular/material-moment-adapter";
import {MatBadgeModule} from "@angular/material/badge";
import {MatButtonModule} from "@angular/material/button";
import {MatCardModule} from "@angular/material/card";
import {MatCheckboxModule} from "@angular/material/checkbox";
import {MatChipsModule} from "@angular/material/chips";
import {MatRippleModule} from "@angular/material/core";
import {MatDatepickerModule} from "@angular/material/datepicker";
import {
  MatDialog,
  MatDialogModule,
} from "@angular/material/dialog";
import {MatDividerModule} from "@angular/material/divider";
import {MatExpansionModule} from "@angular/material/expansion";
import {MatIconModule} from "@angular/material/icon";
import {MatInputModule} from "@angular/material/input";
import {MatListModule} from "@angular/material/list";
import {MatMenuModule} from "@angular/material/menu";
import {MatPaginatorModule} from "@angular/material/paginator";
import {MatProgressBarModule} from "@angular/material/progress-bar";
import {MatProgressSpinnerModule} from "@angular/material/progress-spinner";
import {MatRadioModule} from "@angular/material/radio";
import {MatSelectModule} from "@angular/material/select";
import {MatSidenavModule} from "@angular/material/sidenav";
import {MatSnackBarModule} from "@angular/material/snack-bar";
import {MatTabsModule} from "@angular/material/tabs";
import {MatToolbarModule} from "@angular/material/toolbar";
import {MatTooltipModule} from "@angular/material/tooltip";
import {MatTreeModule} from "@angular/material/tree";
import {MatDialogOverrideService} from "@shared/services/mat-dialog-override.service";
import {MatSlideToggleModule} from "@angular/material/slide-toggle";

const modules = [
  MatProgressSpinnerModule,
  MatToolbarModule,
  MatTabsModule,
  MatInputModule,
  MatButtonModule,
  MatSnackBarModule,
  MatDialogModule,
  MatDividerModule,
  MatDatepickerModule,
  MatMomentDateModule,
  MatSelectModule,
  MatCheckboxModule,
  MatPaginatorModule,
  MatTooltipModule,
  MatTreeModule,
  MatExpansionModule,
  MatCardModule,
  MatListModule,
  MatRadioModule,
  MatProgressBarModule,
  MatMenuModule,
  MatChipsModule,
  PortalModule,
  OverlayModule,
  MatIconModule,
  MatBadgeModule,
  MatRippleModule,
  A11yModule,
  MatSidenavModule,
  MatSlideToggleModule
];

@NgModule({
  declarations: [],
  imports: [
    ...modules,
  ],
  exports: [
    ...modules,
  ],
  providers: [
    {provide: MatDialog, useClass: MatDialogOverrideService},
  ],
  bootstrap: [],
})
export class MaterialModule {
}
