import {isNullOrUndefined} from "solidify-frontend";

export class InMemoryStorage implements Storage {
  private storage: Map<string, string>;

  constructor() {
    this.storage = new Map<string, string>();
  }

  readonly length: number = isNullOrUndefined(this.storage) ? 0 : this.storage.size;

  clear(): void {
    this.storage.clear();
  }

  getItem(key: string): string | null {
    return this.storage.get(key);
  }

  key(index: number): string | null {
    return this.storage[index];
  }

  removeItem(key: string): void {
    this.storage.delete(key);
  }

  setItem(key: string, value: string): void {
    this.storage.set(key, value);
  }
}
