import {Injectable} from "@angular/core";
import {
  PreservationSpaceNotificationState,
  PreservationSpaceNotificationStateModel,
} from "@app/features/preservation-space/notification/stores/preservation-space-notification.state";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {
  State,
  Store,
} from "@ngxs/store";
import {
  PreservationSpaceContributorState,
  PreservationSpaceContributorStateModel,
} from "@preservation-space/contributor/stores/preservation-space-contributor.state";
import {
  PreservationSpaceOrganizationalUnitState,
  PreservationSpaceOrganizationalUnitStateModel,
} from "@preservation-space/organizational-unit/stores/preservation-space-organizational-unit.state";
import {
  BaseStateModel,
  defaultResourceStateInitValue,
} from "solidify-frontend";

export interface PreservationSpaceStateModel extends BaseStateModel {
  preservationSpace_contributor: PreservationSpaceContributorStateModel;
  preservationSpace_notification: PreservationSpaceNotificationStateModel;
  preservationSpace_organizationalUnit: PreservationSpaceOrganizationalUnitStateModel;
}

@Injectable()
@State<PreservationSpaceStateModel>({
  name: LocalStateEnum.preservationSpace,
  defaults: {
    ...defaultResourceStateInitValue(),
    preservationSpace_contributor: null,
    preservationSpace_notification: null,
    preservationSpace_organizationalUnit: null,
  },
  children: [
    PreservationSpaceContributorState,
    PreservationSpaceNotificationState,
    PreservationSpaceOrganizationalUnitState,
  ],
})
export class PreservationSpaceState {
  constructor(protected store: Store) {
  }
}
