import {NgModule} from "@angular/core";
import {PreservationSpaceHomeRoutable} from "@app/features/preservation-space/components/routables/preservation-space-home/preservation-space-home.routable";
import {PreservationSpaceNotificationState} from "@app/features/preservation-space/notification/stores/preservation-space-notification.state";
import {PreservationSpaceNotificationStatusHistoryState} from "@app/features/preservation-space/notification/stores/status-history/preservation-space-notification-status-history.state";
import {PreservationSpaceRoutingModule} from "@app/features/preservation-space/preservation-space-routing.module";
import {PreservationSpaceState} from "@app/features/preservation-space/stores/preservation-space.state";
import {SharedModule} from "@app/shared/shared.module";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";
import {PreservationSpaceContributorDepositState} from "@preservation-space/contributor/stores/contributor-deposit/preservation-space-contributor-deposit.state";
import {PreservationSpaceContributorState} from "@preservation-space/contributor/stores/preservation-space-contributor.state";
import {PreservationSpaceOrganizationalUnitArchiveAclState} from "@preservation-space/organizational-unit/stores/archive-acl/preservation-space-organizational-unit-archive-acl.state";
import {PreservationSpaceOrganizationalUnitDisseminationPolicyState} from "@preservation-space/organizational-unit/stores/dissemination-policy/preservation-space-organizational-unit-dissemination-policy.state";
import {PreservationSpaceOrganizationalUnitInstitutionState} from "@preservation-space/organizational-unit/stores/institution/preservation-space-organizational-unit-institution.state";
import {PreservationSpaceOrganizationalUnitPersonRoleState} from "@preservation-space/organizational-unit/stores/person-role/preservation-space-organizational-unit-person-role.state";
import {PreservationSpaceOrganizationalUnitPreservationPolicyState} from "@preservation-space/organizational-unit/stores/preservation-policy/preservation-space-organizational-unit-preservation-policy.state";
import {PreservationSpaceOrganizationalUnitState} from "@preservation-space/organizational-unit/stores/preservation-space-organizational-unit.state";
import {PreservationSpaceOrganizationalUnitSubmissionPolicyState} from "@preservation-space/organizational-unit/stores/submission-policy/preservation-space-organizational-unit-submission-policy.state";
import {ModuleLoadedEnum} from "@shared/enums/module-loaded.enum";

const routables = [
  PreservationSpaceHomeRoutable,
];
const containers = [];
const dialogs = [];
const presentationals = [];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
  ],
  imports: [
    SharedModule,
    PreservationSpaceRoutingModule,
    TranslateModule.forChild({}),
    NgxsModule.forFeature([
      PreservationSpaceState,
      PreservationSpaceOrganizationalUnitState,
      PreservationSpaceOrganizationalUnitPersonRoleState,
      PreservationSpaceOrganizationalUnitArchiveAclState,
      PreservationSpaceOrganizationalUnitSubmissionPolicyState,
      PreservationSpaceOrganizationalUnitPreservationPolicyState,
      PreservationSpaceOrganizationalUnitDisseminationPolicyState,
      PreservationSpaceOrganizationalUnitInstitutionState,
      PreservationSpaceContributorState,
      PreservationSpaceContributorDepositState,
      PreservationSpaceNotificationState,
      PreservationSpaceNotificationStatusHistoryState,
    ]),
  ],
  entryComponents: [
    ...dialogs,
  ],
  exports: [
    ...routables,
  ],
  providers: [],
})
export class PreservationSpaceModule {
  constructor() {
    window[ModuleLoadedEnum.preservationSpaceModuleLoaded] = true;
  }
}
