import {NgModule} from "@angular/core";
import {RouterModule} from "@angular/router";
import {PreservationSpaceHomeRoutable} from "@app/features/preservation-space/components/routables/preservation-space-home/preservation-space-home.routable";
import {
  AppRoutesEnum,
  PreservationSpaceRoutesEnum,
} from "@app/shared/enums/routes.enum";
import {DlcmRoutes} from "@app/shared/models/dlcm-route.model";
import {ApplicationRolePermissionEnum} from "@shared/enums/application-role-permission.enum";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {ApplicationRoleGuardService} from "@shared/guards/application-role-guard.service";

const routes: DlcmRoutes = [
  {
    path: AppRoutesEnum.root,
    redirectTo: PreservationSpaceRoutesEnum.organizationalUnit,
    pathMatch: "full",
  },
  {
    path: AppRoutesEnum.root,
    component: PreservationSpaceHomeRoutable,
    data: {},
    children: [
      {
        path: PreservationSpaceRoutesEnum.organizationalUnit,
        // @ts-ignore Dynamic import
        loadChildren: () => import("./organizational-unit/preservation-space-organizational-unit.module").then(m => m.PreservationSpaceOrganizationalUnitModule),
        data: {
          breadcrumb: LabelTranslateEnum.organizationalUnits,
          permission: ApplicationRolePermissionEnum.userPermission,
        },
        canActivate: [ApplicationRoleGuardService],
      },
      {
        path: PreservationSpaceRoutesEnum.contributor,
        // @ts-ignore Dynamic import
        loadChildren: () => import("./contributor/preservation-space-contributor.module").then(m => m.PreservationSpaceContributorModule),
        data: {
          breadcrumb: LabelTranslateEnum.contributors,
        },
        canActivate: [ApplicationRoleGuardService],
      },
      {
        path: PreservationSpaceRoutesEnum.notificationInbox,
        // @ts-ignore Dynamic import
        loadChildren: () => import("./notification/preservation-space-notification.module").then(m => m.PreservationSpaceNotificationModule),
        data: {
          breadcrumb: LabelTranslateEnum.notifications,
        },
        canActivate: [ApplicationRoleGuardService],
      },
      {
        path: PreservationSpaceRoutesEnum.notificationSent,
        // @ts-ignore Dynamic import
        loadChildren: () => import("./notification/preservation-space-notification.module").then(m => m.PreservationSpaceNotificationModule),
        data: {
          breadcrumb: LabelTranslateEnum.sentRequests,
        },
        canActivate: [ApplicationRoleGuardService],
      },
    ],
  },
  {
    path: PreservationSpaceRoutesEnum.aipSteward,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./aip-steward/preservation-space-aip-steward.module").then(m => m.PreservationSpaceAipStewardModule),
    data: {
      breadcrumb: LabelTranslateEnum.aip,
      noBreadcrumbLink: true,
    },
    canActivate: [ApplicationRoleGuardService],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class PreservationSpaceRoutingModule {
}
