import {OrganizationalUnitSubmissionPolicy} from "@admin/models/organizational-unit-submission-policy.model";
import {SubmissionPolicy} from "@models";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {
  Relation2TiersAction,
  Relation2TiersNameSpace,
  TypeDefaultAction,
} from "solidify-frontend";

const state = LocalStateEnum.preservationSpace_organizationalUnit_submissionPolicy;

export namespace PreservationSpaceOrganizationalUnitSubmissionPolicyAction {

  @TypeDefaultAction(state)
  export class GetAll extends Relation2TiersAction.GetAll {
  }

  @TypeDefaultAction(state)
  export class GetAllSuccess extends Relation2TiersAction.GetAllSuccess<SubmissionPolicy> {
  }

  @TypeDefaultAction(state)
  export class GetAllFail extends Relation2TiersAction.GetAllFail {
  }

  @TypeDefaultAction(state)
  export class GetById extends Relation2TiersAction.GetById {
  }

  @TypeDefaultAction(state)
  export class GetByIdSuccess extends Relation2TiersAction.GetByIdSuccess<SubmissionPolicy> {
  }

  @TypeDefaultAction(state)
  export class GetByIdFail extends Relation2TiersAction.GetByIdFail {
  }

  @TypeDefaultAction(state)
  export class Update extends Relation2TiersAction.Update {
    constructor(public parentId: string, public newResId: string[], public oldDefaultResId: string, public newDefaultResId: string) {
      super(parentId, newResId);
    }
  }

  @TypeDefaultAction(state)
  export class UpdateSuccess extends Relation2TiersAction.UpdateSuccess {
  }

  @TypeDefaultAction(state)
  export class UpdateFail extends Relation2TiersAction.UpdateFail {
  }

  @TypeDefaultAction(state)
  export class UpdateRelation extends Relation2TiersAction.UpdateRelation<OrganizationalUnitSubmissionPolicy> {
  }

  @TypeDefaultAction(state)
  export class UpdateRelationSuccess extends Relation2TiersAction.UpdateRelationSuccess<OrganizationalUnitSubmissionPolicy> {
  }

  @TypeDefaultAction(state)
  export class UpdateRelationFail extends Relation2TiersAction.UpdateRelationFail<OrganizationalUnitSubmissionPolicy> {
  }

  @TypeDefaultAction(state)
  export class Create extends Relation2TiersAction.Create {
  }

  @TypeDefaultAction(state)
  export class CreateSuccess extends Relation2TiersAction.CreateSuccess {
  }

  @TypeDefaultAction(state)
  export class CreateFail extends Relation2TiersAction.CreateFail {
  }

  @TypeDefaultAction(state)
  export class DeleteList extends Relation2TiersAction.DeleteList {
  }

  @TypeDefaultAction(state)
  export class DeleteListSuccess extends Relation2TiersAction.DeleteListSuccess {
  }

  @TypeDefaultAction(state)
  export class DeleteListFail extends Relation2TiersAction.DeleteListFail {
  }

  @TypeDefaultAction(state)
  export class Delete extends Relation2TiersAction.Delete {
  }

  @TypeDefaultAction(state)
  export class DeleteSuccess extends Relation2TiersAction.DeleteSuccess {
  }

  @TypeDefaultAction(state)
  export class DeleteFail extends Relation2TiersAction.DeleteFail {
  }
}

export const preservationSpaceOrganizationalUnitSubmissionPolicyActionNameSpace: Relation2TiersNameSpace = PreservationSpaceOrganizationalUnitSubmissionPolicyAction;
