import {HttpClient} from "@angular/common/http";
import {Injectable} from "@angular/core";
import {PreservationSpaceOrganizationalUnitPersonRoleAction} from "@app/features/preservation-space/organizational-unit/stores/person-role/preservation-space-organizational-unit-person-role.action";
import {
  PreservationSpaceOrganizationalUnitPersonRoleState,
  PreservationSpaceOrganizationalUnitPersonRoleStateModel,
} from "@app/features/preservation-space/organizational-unit/stores/person-role/preservation-space-organizational-unit-person-role.state";
import {
  PreservationSpaceOrganizationalUnitAction,
  preservationSpaceOrganizationalUnitActionNameSpace,
} from "@app/features/preservation-space/organizational-unit/stores/preservation-space-organizational-unit.action";
import {
  AccessResourceApiEnum,
  AdminResourceApiEnum,
} from "@app/shared/enums/api.enum";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {RoutesEnum} from "@app/shared/enums/routes.enum";
import {DepositStateModel} from "@deposit/stores/deposit.state";
import {OrganizationalUnit} from "@models";
import {
  Action,
  Actions,
  ofActionCompleted,
  Selector,
  State,
  StateContext,
  Store,
} from "@ngxs/store";
import {
  PreservationSpaceOrganizationalUnitArchiveAclState,
  PreservationSpaceOrganizationalUnitArchiveAclStateModel,
} from "@preservation-space/organizational-unit/stores/archive-acl/preservation-space-organizational-unit-archive-acl.state";
import {
  PreservationSpaceOrganizationalUnitDisseminationPolicyState,
  PreservationSpaceOrganizationalUnitDisseminationPolicyStateModel,
} from "@preservation-space/organizational-unit/stores/dissemination-policy/preservation-space-organizational-unit-dissemination-policy.state";
import {PreservationSpaceOrganizationalUnitInstitutionAction} from "@preservation-space/organizational-unit/stores/institution/preservation-space-organizational-unit-institution.action";
import {
  PreservationSpaceOrganizationalUnitInstitutionState,
  PreservationSpaceOrganizationalUnitInstitutionStateModel,
} from "@preservation-space/organizational-unit/stores/institution/preservation-space-organizational-unit-institution.state";
import {
  PreservationSpaceOrganizationalUnitPreservationPolicyState,
  PreservationSpaceOrganizationalUnitPreservationPolicyStateModel,
} from "@preservation-space/organizational-unit/stores/preservation-policy/preservation-space-organizational-unit-preservation-policy.state";
import {
  PreservationSpaceOrganizationalUnitSubmissionPolicyState,
  PreservationSpaceOrganizationalUnitSubmissionPolicyStateModel,
} from "@preservation-space/organizational-unit/stores/submission-policy/preservation-space-organizational-unit-submission-policy.state";
import {ErrorsSkipperService} from "@shared/services/errors-skipper.service";
import {SecurityService} from "@shared/services/security.service";
import {ResourceLogoStateModel} from "@shared/stores/resource-logo/resource-logo-state.model";
import {
  defaultResourceLogoStateInitValue,
  ResourceLogoState,
  ResourceLogoStateModeEnum,
} from "@shared/stores/resource-logo/resource-logo.state";
import {SharedRoleAction} from "@shared/stores/role/shared-role.action";
import {Observable} from "rxjs";
import {
  catchError,
  tap
} from "rxjs/operators";
import {
  ApiService,
  CollectionTyped,
  defaultAssociationStateInitValue,
  defaultRelation2TiersStateInitValue,
  defaultRelation3TiersStateInitValue,
  defaultResourceStateInitValue,
  isArray,
  isFalse,
  isNotNullNorUndefined,
  isNullOrUndefined,
  isTrue,
  isUndefined,
  MARK_AS_TRANSLATABLE,
  MemoizedUtil,
  NotificationService,
  OverrideDefaultAction,
  Relation3TiersForm,
  SolidifyStateError,
  StoreUtil,
  urlSeparator,
} from "solidify-frontend";

export interface PreservationSpaceOrganizationalUnitStateModel extends ResourceLogoStateModel<OrganizationalUnit> {
  [LocalStateEnum.preservationSpace_organizationalUnit_personRole]: PreservationSpaceOrganizationalUnitPersonRoleStateModel;
  [LocalStateEnum.preservationSpace_organizationalUnit_archiveAcl]: PreservationSpaceOrganizationalUnitArchiveAclStateModel;
  [LocalStateEnum.preservationSpace_organizationalUnit_submissionPolicy]: PreservationSpaceOrganizationalUnitSubmissionPolicyStateModel;
  [LocalStateEnum.preservationSpace_organizationalUnit_preservationPolicy]: PreservationSpaceOrganizationalUnitPreservationPolicyStateModel;
  [LocalStateEnum.preservationSpace_organizationalUnit_disseminationPolicy]: PreservationSpaceOrganizationalUnitDisseminationPolicyStateModel;
  [LocalStateEnum.preservationSpace_organizationalUnit_institution]: PreservationSpaceOrganizationalUnitInstitutionStateModel;
  currentUserIsManager: boolean;
}

@Injectable()
@State<PreservationSpaceOrganizationalUnitStateModel>({
  name: LocalStateEnum.preservationSpace_organizationalUnit,
  defaults: {
    ...defaultResourceLogoStateInitValue(),
    currentUserIsManager: undefined,
    [LocalStateEnum.preservationSpace_organizationalUnit_personRole]: {...defaultRelation3TiersStateInitValue()},
    [LocalStateEnum.preservationSpace_organizationalUnit_archiveAcl]: {...defaultResourceStateInitValue()},
    [LocalStateEnum.preservationSpace_organizationalUnit_submissionPolicy]: {...defaultRelation2TiersStateInitValue()},
    [LocalStateEnum.preservationSpace_organizationalUnit_preservationPolicy]: {...defaultRelation2TiersStateInitValue()},
    [LocalStateEnum.preservationSpace_organizationalUnit_disseminationPolicy]: {...defaultRelation2TiersStateInitValue()},
    [LocalStateEnum.preservationSpace_organizationalUnit_institution]: {...defaultAssociationStateInitValue()},
  },
  children: [
    PreservationSpaceOrganizationalUnitPersonRoleState,
    PreservationSpaceOrganizationalUnitArchiveAclState,
    PreservationSpaceOrganizationalUnitDisseminationPolicyState,
    PreservationSpaceOrganizationalUnitSubmissionPolicyState,
    PreservationSpaceOrganizationalUnitPreservationPolicyState,
    PreservationSpaceOrganizationalUnitInstitutionState,
  ],
})
export class PreservationSpaceOrganizationalUnitState extends ResourceLogoState<PreservationSpaceOrganizationalUnitStateModel, OrganizationalUnit> {

  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions,
              protected errorsSkipperService: ErrorsSkipperService,
              private _securityService: SecurityService,
              protected readonly _httpClient: HttpClient) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: preservationSpaceOrganizationalUnitActionNameSpace,
      routeRedirectUrlAfterSuccessCreateAction: (resId: string) => RoutesEnum.preservationSpaceOrganizationalUnitDetail + urlSeparator + resId,
      routeRedirectUrlAfterSuccessUpdateAction: (resId: string) => RoutesEnum.preservationSpaceOrganizationalUnitDetail + urlSeparator + resId,
      routeRedirectUrlAfterSuccessDeleteAction: RoutesEnum.preservationSpaceOrganizationalUnit,
      notificationResourceCreateSuccessTextToTranslate: MARK_AS_TRANSLATABLE("organizationalUnit.notification.resource.create"),
      notificationResourceDeleteSuccessTextToTranslate: MARK_AS_TRANSLATABLE("organizationalUnit.notification.resource.delete"),
      notificationResourceUpdateSuccessTextToTranslate: MARK_AS_TRANSLATABLE("organizationalUnit.notification.resource.update"),
      keepCurrentStateAfterUpdate: true,
    }, _httpClient, ResourceLogoStateModeEnum.logo);
  }

  protected get _urlResource(): string {
    const accessResourceApiEnum = AccessResourceApiEnum.organizationalUnits;
    const adminResourceApiEnum = AdminResourceApiEnum.organizationalUnits;
    if (isNullOrUndefined(this.store)) {
      return accessResourceApiEnum;
    }
    const organizationalUnit = MemoizedUtil.currentSnapshot(this.store, PreservationSpaceOrganizationalUnitState);
    return this._securityService.isManagerOfOrgUnit(organizationalUnit?.resId) ? adminResourceApiEnum : accessResourceApiEnum;
  }

  protected get _urlLogoResource(): string {
    return this._urlResource;
  }

  @Selector()
  static currentUserIsManager(state: PreservationSpaceOrganizationalUnitStateModel): boolean | undefined {
    return state.currentUserIsManager;
  }

  @Selector()
  static currentTitle(state: PreservationSpaceOrganizationalUnitStateModel): string | undefined {
    if (isNullOrUndefined(state.current)) {
      return undefined;
    }
    return state.current.name;
  }

  @Selector()
  static isLoading(state: PreservationSpaceOrganizationalUnitStateModel): boolean {
    return StoreUtil.isLoadingState(state);
  }

  @Selector()
  static isLoadingWithDependency(state: PreservationSpaceOrganizationalUnitStateModel): boolean {
    return this.isLoading(state)
      || isUndefined(this.currentUserIsManager(state))
      || StoreUtil.isLoadingState(state.preservationSpace_organizationalUnit_personRole)
      || StoreUtil.isLoadingState(state.preservationSpace_organizationalUnit_institution);

  }

  @Selector()
  static isReadyToBeDisplayed(state: PreservationSpaceOrganizationalUnitStateModel): boolean {
    return !isNullOrUndefined(state.current)
      && !isUndefined(this.currentUserIsManager(state))
      && (isFalse(this.currentUserIsManager(state)) || !isNullOrUndefined(state.preservationSpace_organizationalUnit_personRole.selected))
      && (isFalse(this.currentUserIsManager(state)) || !isNullOrUndefined(state.preservationSpace_organizationalUnit_institution.selected));

  }

  @Action(PreservationSpaceOrganizationalUnitAction.LoadResource)
  loadResource(ctx: StateContext<DepositStateModel>, action: PreservationSpaceOrganizationalUnitAction.LoadResource): Observable<any> {
    ctx.patchState({
      isLoadingCounter: ctx.getState().isLoadingCounter + 1,
    });

    return StoreUtil.dispatchParallelActionAndWaitForSubActionsCompletion(ctx, [
      // ...(this._urlResource === AdminResourceApiEnum.organizationalUnits ? [
      //   {
      //     action: new SharedPreservationPolicyAction.GetAll(undefined, false, false),
      //     subActionCompletions: [
      //       this.actions$.pipe(ofActionCompleted(SharedPreservationPolicyAction.GetAllSuccess)),
      //       this.actions$.pipe(ofActionCompleted(SharedPreservationPolicyAction.GetAllFail)),
      //     ],
      //   },
      //   {
      //     action: new SharedSubmissionPolicyAction.GetAll(undefined, false, false),
      //     subActionCompletions: [
      //       this.actions$.pipe(ofActionCompleted(SharedSubmissionPolicyAction.GetAllSuccess)),
      //       this.actions$.pipe(ofActionCompleted(SharedSubmissionPolicyAction.GetAllFail)),
      //     ],
      //   },
      //   {
      //     action: new SharedDisseminationPolicyAction.GetAll(undefined, false, false),
      //     subActionCompletions: [
      //       this.actions$.pipe(ofActionCompleted(SharedDisseminationPolicyAction.GetAllSuccess)),
      //       this.actions$.pipe(ofActionCompleted(SharedDisseminationPolicyAction.GetAllFail)),
      //     ],
      //   },
      // ] : []),
      {
        action: new SharedRoleAction.GetAll(undefined, false, false),
        subActionCompletions: [
          this.actions$.pipe(ofActionCompleted(SharedRoleAction.GetAllSuccess)),
          this.actions$.pipe(ofActionCompleted(SharedRoleAction.GetAllFail)),
        ],
      },
    ]).pipe(
      tap(success => {
        if (success) {
          ctx.dispatch(new PreservationSpaceOrganizationalUnitAction.LoadResourceSuccess(action));
        } else {
          ctx.dispatch(new PreservationSpaceOrganizationalUnitAction.LoadResourceFail(action));
        }
      }),
    );
  }

  @OverrideDefaultAction()
  @Action(PreservationSpaceOrganizationalUnitAction.GetByIdSuccess)
  getByIdSuccess(ctx: StateContext<PreservationSpaceOrganizationalUnitStateModel>, action: PreservationSpaceOrganizationalUnitAction.GetByIdSuccess): void {
    ctx.patchState({
      current: action.model,
      isLoadingCounter: ctx.getState().isLoadingCounter - 1,
    });

    ctx.dispatch(new PreservationSpaceOrganizationalUnitAction.ComputeCurrentUserIsManager());

    if (isNotNullNorUndefined(action.model.logo)) {
      ctx.dispatch(new PreservationSpaceOrganizationalUnitAction.GetPhoto(action.model.resId));
    }
  }

  @Action(PreservationSpaceOrganizationalUnitAction.ComputeCurrentUserIsManager)
  computeCurrentUserIsManager(ctx: StateContext<PreservationSpaceOrganizationalUnitStateModel>, action: PreservationSpaceOrganizationalUnitAction.ComputeCurrentUserIsManager): void | boolean {
    const isManager = this._securityService.isManagerOfOrgUnit(ctx.getState().current.resId);
    ctx.dispatch(new PreservationSpaceOrganizationalUnitAction.SaveCurrentUserIsManagerAndRetrievePersonRoleIfManager(isManager));
    return isManager;
  }

  @Action(PreservationSpaceOrganizationalUnitAction.SaveCurrentUserIsManager)
  saveCurrentUserIsManager(ctx: StateContext<PreservationSpaceOrganizationalUnitStateModel>, action: PreservationSpaceOrganizationalUnitAction.SaveCurrentUserIsManager): void {
    ctx.patchState({
      currentUserIsManager: action.isManager,
    });
  }

  @Action(PreservationSpaceOrganizationalUnitAction.SaveCurrentUserIsManagerAndRetrievePersonRoleIfManager)
  saveCurrentUserIsManagerAndRetrievePersonRoleIfManager(ctx: StateContext<PreservationSpaceOrganizationalUnitStateModel>, action: PreservationSpaceOrganizationalUnitAction.SaveCurrentUserIsManagerAndRetrievePersonRoleIfManager): void {
    ctx.dispatch(new PreservationSpaceOrganizationalUnitAction.SaveCurrentUserIsManager(action.isManager));
    if (isTrue(action.isManager)) {
      const orgUnitId = ctx.getState().current.resId;
      this.store.dispatch(new PreservationSpaceOrganizationalUnitPersonRoleAction.GetAll(orgUnitId));
    }
  }

  @OverrideDefaultAction()
  @Action(PreservationSpaceOrganizationalUnitAction.Create)
  create(ctx: StateContext<PreservationSpaceOrganizationalUnitStateModel>, action: PreservationSpaceOrganizationalUnitAction.Create): Observable<OrganizationalUnit> {
    return super.internalCreate(ctx, action)
      .pipe(
        tap(model => {
          this.updateSubResource(model, action, ctx)
            .subscribe(success => {
              if (success) {
                ctx.dispatch(new PreservationSpaceOrganizationalUnitAction.CreateSuccess(action, model));
              } else {
                ctx.dispatch(new PreservationSpaceOrganizationalUnitAction.CreateFail(action));
              }
            });
        }),
      );
  }

  @OverrideDefaultAction()
  @Action(PreservationSpaceOrganizationalUnitAction.Update)
  update(ctx: StateContext<PreservationSpaceOrganizationalUnitStateModel>, action: PreservationSpaceOrganizationalUnitAction.Update): Observable<OrganizationalUnit> {
    return super.internalUpdate(ctx, action)
      .pipe(
        tap(model => {
          this.updateSubResource(model, action, ctx)
            .subscribe(success => {
              if (success) {
                ctx.dispatch(new PreservationSpaceOrganizationalUnitAction.UpdateSuccess(action, model));
              } else {
                ctx.dispatch(new PreservationSpaceOrganizationalUnitAction.UpdateFail(action));
              }
            });
        }),
      );
  }

  @Action(PreservationSpaceOrganizationalUnitAction.LoadOnlyMyOrgUnits)
  loadOnlyMyOrgUnits(ctx: StateContext<PreservationSpaceOrganizationalUnitStateModel>, action: PreservationSpaceOrganizationalUnitAction.LoadOnlyMyOrgUnits): Observable<CollectionTyped<OrganizationalUnit>> {
    ctx.patchState({
      isLoadingCounter: ctx.getState().isLoadingCounter + 1,
      queryParameters: StoreUtil.getQueryParametersToApply(action.queryParameters, ctx),
    });

    return this.apiService.get<OrganizationalUnit>(AdminResourceApiEnum.authorizedOrganizationalUnits, ctx.getState().queryParameters)
      .pipe(
        tap((collection: CollectionTyped<OrganizationalUnit>) => {
          ctx.dispatch(new PreservationSpaceOrganizationalUnitAction.LoadOnlyMyOrgUnitsSuccess(action, collection));
        }),
        catchError(error => {
          ctx.dispatch(new PreservationSpaceOrganizationalUnitAction.LoadOnlyMyOrgUnitsFail(action));
          throw new SolidifyStateError(this, error);
        }),
      );
  }

  @Action(PreservationSpaceOrganizationalUnitAction.LoadOnlyMyOrgUnitsSuccess)
  loadOnlyMyOrgUnitsSuccess(ctx: StateContext<PreservationSpaceOrganizationalUnitStateModel>, action: PreservationSpaceOrganizationalUnitAction.LoadOnlyMyOrgUnitsSuccess): void {
    const queryParameters = StoreUtil.updateQueryParameters(ctx, action.list);

    ctx.patchState({
      list: action.list._data,
      total: action.list._page.totalItems,
      isLoadingCounter: ctx.getState().isLoadingCounter - 1,
      queryParameters,
    });
  }

  @Action(PreservationSpaceOrganizationalUnitAction.LoadOnlyMyOrgUnitsFail)
  loadOnlyMyOrgUnitsFail(ctx: StateContext<PreservationSpaceOrganizationalUnitStateModel>, action: PreservationSpaceOrganizationalUnitAction.LoadOnlyMyOrgUnitsFail): void {
    ctx.patchState({
      isLoadingCounter: ctx.getState().isLoadingCounter - 1,
    });
  }

  private updateSubResource(model: OrganizationalUnit, action: PreservationSpaceOrganizationalUnitAction.Create | PreservationSpaceOrganizationalUnitAction.Update, ctx: StateContext<PreservationSpaceOrganizationalUnitStateModel>): Observable<boolean> {
    const orgUnitId = model.resId;
    const newPersonRole = action.modelFormControlEvent.formControl.get("personRole").value as Relation3TiersForm[];
    newPersonRole.forEach((elem) => {
      if (!isNullOrUndefined(elem.listId) && !isArray(elem.listId)) {
        elem.listId = [elem.listId];
      }
    });

    const newInstitutionsIds = action.modelFormControlEvent.model.institutions.map(p => p.resId);

    return StoreUtil.dispatchSequentialActionAndWaitForSubActionsCompletion(ctx, [
      {
        action: new PreservationSpaceOrganizationalUnitPersonRoleAction.Update(orgUnitId, newPersonRole),
        subActionCompletions: [
          this.actions$.pipe(ofActionCompleted(PreservationSpaceOrganizationalUnitPersonRoleAction.UpdateSuccess)),
          this.actions$.pipe(ofActionCompleted(PreservationSpaceOrganizationalUnitPersonRoleAction.UpdateFail)),
        ],
      },
      {
        action: new PreservationSpaceOrganizationalUnitInstitutionAction.Update(orgUnitId, newInstitutionsIds),
        subActionCompletions: [
          this.actions$.pipe(ofActionCompleted(PreservationSpaceOrganizationalUnitInstitutionAction.UpdateSuccess)),
          this.actions$.pipe(ofActionCompleted(PreservationSpaceOrganizationalUnitInstitutionAction.UpdateFail)),
        ],
      },
    ]);
  }
}
